import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { AmosFetch } from '../../../utils/processor';
import { Modal } from 'amos-antd';
import { message } from 'amos-framework';
import OltSerUrl from '../../../consts/urlConsts';
import TableCard from './TableCard';
import AddProtocolCard from './AddProtocolCard';

class TableContainer extends Component {
  constructor(props) {
    super(props);
    this.state = {
    };
  }


  componentWillMount() {
  }

  componentWillReceiveProps(nextProps) {
  }

  delInfo = (id) => {
    //delete
    let url = `${OltSerUrl.protocolDelete}/${id}`;
    AmosFetch.del(url).then(res => {
      if (res.ok) {
        return res.text();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
    //重新刷新数据
      message.success('删除成功！');
      let { visibility,criterias } = this.props;
      this.props.requestMethod(visibility,criterias);
    });
  }
  //动态组表格
  showTable = () => {
    let dataList = this.props.dataList;
    let res = [];
    let { visibility,isDel } = this.props;
    //如果是私有协议，则添加新建按钮
    if (visibility === '1'){
      res.push(<AddProtocolCard key={0} {...this.props} />);
    }
    if ( dataList.length > 0  ) {
      dataList.map(data=>{
        res.push(
          <TableCard
            key={data.id}
            {...this.props}
            cardData={data}
            delInfo={this.delInfo}
            isDel={isDel}
          />
        );
      });
    }
    return res;
  }

  render() {
    return (
      <div className='table-container'>
        {this.showTable()}
      </div>
    );
  }
}

TableContainer.propTypes = {
  isDel: PropTypes.bool,
  criterias: PropTypes.array,
  visibility: PropTypes.string,
  requestMethod: PropTypes.func,
  dataList: PropTypes.any
};

export default TableContainer;
