import { strToTime,dateToHour } from './DateUtil';

/**
 * 根据日期字符串获取实时监测数据起始时间戳和结束时间戳
 * str：时间格式字符串
 * hour：改时间之前的小时数
 */
export const getBeforeByStr = (str,hour) => {
  let end =  new Date(strToTime(dateToHour(strToTime(str) + 1 * 60 * 60 * 1000)));
  let startTime = end.getTime() - (hour + 1) * 60 * 60 * 1000;
  return [ startTime,end.getTime() ];
};

/**
 * 根据日期字符串获取日视图起始时间戳和结束时间戳
 * 日视图为当天凌晨0点到晚上12点
 */
export const getDayTimeByStr = (str) => {
  let start =  new Date(strToTime(str));
  let startTime = new Date(start.toLocaleDateString()).getTime();
  let endTime = startTime + 24 * 60 * 60 * 1000;
  return [ startTime,endTime ];
};
/**
 * 根据日期字符串获取周视图起始时间戳和结束时间戳
 * 周视图为前3天后4天
 */
export const getWeekTimeByStr = (str) => {
  let start =  new Date(strToTime(str));
  let startTime = new Date(start.toLocaleDateString()).getTime();
  startTime = startTime - 3 * 24 * 60 * 60 * 1000;
  let endTime = startTime + 7 * 24 * 60 * 60 * 1000;
  return [ startTime,endTime ];
};
/**
 * 根据日期字符串获取月视图起始时间戳和结束时间戳
 * 月视图为前21天后9天
 */
export const getMonthTimeByStr = (str) => {
  let start =  new Date(strToTime(str));
  let startTime = new Date(start.toLocaleDateString()).getTime();
  startTime = startTime - 21 * 24 * 60 * 60 * 1000;
  let endTime = startTime + 30 * 24 * 60 * 60 * 1000;
  return [ startTime,endTime ];
};
