import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form,Input,Modal,Button,Row,Col } from 'amos-antd';

const createForm = Form.create();
/**
 *
 * @class AlarmDetail
 * @extends {Component}
 */
class AlarmDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      subVisible: false,
      inputStr: '告警已处理！'
    };
  }

  componentDidMount(){

  }

  onClick = () => {
    this.setState({ visible: true });
  }

  /**
   * 打开新增监测规则对话框
   */
  onSubClick = () => {
    this.setState({ subVisible: true });
  }

  onChange = (e) =>{
    this.setState({
      inputStr: e.target.value
    });
  }

  handleCancel = (obj) => {
    this.setState({ visible: false });
  }

  /**
   * 关闭新增监测规则对话框
   */
  handleSubCancel = () => {
    this.setState({ subVisible: false });
  }

  handleSubmit = () => {
    this.handleSubCancel();
    let ids = [];
    ids.push(this.props.alarmInfo.id);
    this.props.clearAlarm(this.state.inputStr,ids);
  }

  render() {
    let { alarmInfo } = this.props;
    let { inputStr } = this.state;
    let { name,level,status,type,durationDate,count,descr } = alarmInfo;
    let destroyOnClose = true;
    let maskClosable = false;
    return (
      <div className='alarm-detail-root' >
        <label onClick={this.onClick} >详情</label>
        <Modal className='alarm-detail-modal' title='告警详情' visible={this.state.visible} onCancel={this.handleCancel} footer={null} width={700}>
          <div className='alarm-detail-content'>
            <Row>
              <Col className='alarm-detail-source-name' span={5}>
                告警源:
              </Col>
              <Col className='alarm-detail-source-value' span={19}>
                {name}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-descr-name' span={5}>
                描述:
              </Col>
              <Col title={descr} className='alarm-detail-descr-value' span={19}>
                {descr}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-level-name' span={5}>
                告警级别:
              </Col>
              <Col className='alarm-detail-level-value' span={19}>
                {level === 1 ? '一级' : level === 2 ? '二级' : '三级'}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-type-name' span={5}>
                告警类型:
              </Col>
              <Col className='alarm-detail-type-value' span={19}>
                {type === 1 ? '指标越界' : type === 2 ? '采集异常' : '设备掉线'}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-status-name' span={5}>
                状态:
              </Col>
              <Col className='alarm-detail-status-value' span={19}>
                {status === 1 ? '未处理' : status === 2 ? '历史告警' : '已删除'}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-duration-name' span={5}>
                持续时间:
              </Col>
              <Col className='alarm-detail-duration-value' span={19}>
                {durationDate}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-count-name' span={5}>
                告警次数:
              </Col>
              <Col className='alarm-detail-count-value' span={19}>
                {count}
              </Col>
            </Row>
            <Row style={{ 'padding-top': '15px' }}>
              <Col className='alarm-detail-clear' span={4} offset={20} onClick={this.onSubClick}>
                清除
                <Modal  width={333} className='clear-alarm-modal' title='清除告警信息' visible={this.state.subVisible}  footer={null} onCancel={this.handleSubCancel} maskClosable={maskClosable} destroyOnClose={destroyOnClose} >
                  <div>
                    <Row style={{ marginTop: '20px',textAlign: 'center' }} >
                      <Col span={24}>
                        <span style={{ 'font-size': '13px' }}>备注：</span><Input value={inputStr} style={{ width: '250px','font-size': '13px' }} onChange={this.onChange} />
                      </Col>
                    </Row>
                  </div>
                  <Row style={{ 'padding-top': '30px' }}>
                    <Col className='alarm-detail-clear' span={4} offset={6} onClick={this.handleSubmit}>
                      确定
                    </Col>
                    <Col className='alarm-detail-cancel' span={4} offset={2} onClick={this.handleSubCancel}>
                      取消
                    </Col>
                  </Row>
                </Modal>
              </Col>
            </Row>
          </div>
        </Modal>
      </div>
    );
  }
}

AlarmDetail.propTypes = {
  form: PropTypes.any,
  alarmInfo: PropTypes.any,
  clearAlarm: PropTypes.func
};

export default createForm(AlarmDetail);
