import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Switch, Input } from 'amos-framework';

class LibHeader extends Component {

  static propTypes = {
    title: PropTypes.string,
    startUseAllSwitchChange: PropTypes.func,
    checked: PropTypes.bool,
    onSearch: PropTypes.func
  };

  render() {
    const { startUseAllSwitchChange, checked,onSearch } = this.props;
    return (
      <div className="rule-lib-header">
        <div className="rule-lib-header-content">
          <div className="rule-lib-header-right">
            <Switch
              className="rule-lib-all-switch"
              onLabel="启用全部"
              offLabel="未启用全部"
              onChange={startUseAllSwitchChange}
              onOff={checked}
              />
            <div className='search-rule'>
              <Input placeholder="输入内容" className="goit-search-ipt" onChange={onSearch} />
            </div>
          </div>
        </div>
      </div>
    );
  }
}

export default LibHeader;
