import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { initStageView } from './../../../services/ruleDesignService';
import OutputNodeConfig from './OutputNodeConfig';
import DataSourceConfig from './DataSourceConfig';

/**
 * 配置界面
 *
 * @class RuleConfigPanel
 * @extends {Component}
 */
class RuleConfigPanel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      capacityBasicInfo: {},
      interfaceBasicInfo: {},
      ruleSubObj: {}
    };
  }

  componentDidMount(){
    this.queryRuleObj();
  }


  componentWillReceiveProps(nextProps) {

  }

  getConfigPanel = () => {
    let { nodeType } = this.props.config;
    let type = nodeType;
    let content = [];
    if (type === 'datanodeDevice' || type === 'datanodeCurrentUser'
    || type === 'datanodeTask' || type === 'datanodeView') {
      content.push(<DataSourceConfig
        {...this.props}
      />);
    } else if (type === 'outputEmail' || type === 'outputMqtt' || type === 'outputTcp') {
      content.push(<OutputNodeConfig
        {...this.props}
      />);
    } else if (type === 'alarmAll') {
      // content.push();
    }
    return content;
  }

  queryRuleObj = () => {
    const { objId } = this.props;
    if (objId){
      initStageView(objId).then(data => {
        this.setState({
          ruleSubObj: data.rule
        });
      });
    }
  }

  render() {
    return (
      <div className='config-panel'>
        {this.getConfigPanel()}
      </div>
    );
  }
}

RuleConfigPanel.propTypes = {
  config: PropTypes.object,
  objId: PropTypes.string,
  closeTriggerDesigner: PropTypes.func
};

export default RuleConfigPanel;
