import { parseText } from 'amos-tool';

export const modelMapping = {
  flowAction: 'flowAction',
  trigger: 'trigger',
  status: 'status',
  object: 'object',
  note: 'note'
};

export const stageIconPath = '/src/assets/iot/rule/{iconName}.png';

const _nodelList = [
  { key: 'datanode', icon: 'ele-item-datanode', text: '数据源', children: [
    { key: 'datanode-device', text: '设备', type: 'datanodeDevice' },
    { key: 'datanode-current-user', text: '当前用户', type: 'datanodeCurrentUser' },
    { key: 'datanode-sub-user', text: '子用户', type: 'datanodeSubUser' }
  ] },
  { key: 'alarm', icon: 'ele-item-alarm', text: '告警节点', children: [
    { key: 'alarm-all', text: '全部告警', type: 'alarmAll' },
    { key: 'alarm-quota', text: '指标越界告警', type: 'alarmQuota' },
    { key: 'alarm-collect', text: '采集异常告警', type: 'alarmCollect' },
    { key: 'alarm-device-offline', text: '设备掉线告警', type: 'alarmDeviceOffline' }
  ] },
  { key: 'output', icon: 'ele-item-output', text: '输出节点', children: [
    { key: 'output-email', text: 'email', type: 'outputEmail' },
    { key: 'output-mqtt', text: 'mqtt', type: 'outputMqtt' },
    { key: 'output-tcp', text: 'tcp', type: 'outputTcp' }
  ] },
  { key: 'requestresponse', icon: 'ele-item-requestresponse', text: '请求/应答', children: [
    { key: 'requestresponse-http', text: 'http request', type: 'requestresponseHttp' },
    { key: 'requestresponse-tcp', text: 'tcp request', type: 'requestresponseTcp' }
  ] }
];

const _linkList = [
  { key: 'solid-link', type: 'solid', text: '实线', icon: 'link-item-solid' },
  { key: 'dashed-link', type: 'solid', text: '虚线', icon: 'link-item-dashed' }
];

const _statusCatalog = [
  { key: 'trigger', type: 'trigger', text: '触发器', icon: 'ele-catalog-trigger' }
];

const completeData = (datas) => {
  return datas.map(m => {
    (m.children || []).map(mc => {
      mc.icon = parseText(stageIconPath, { iconName: mc.key });
    });
    return m;
  });
};

export const nodelList = completeData(_nodelList);
export const linkList = completeData(_linkList);

export const catalogOperatorIcon = '/src/assets/iot/rule/ele-catalog-operator.png';
export const statusCatalog = completeData(_statusCatalog);

export const eleType = {
  datanodeDevice: 'datanodeDevice',
  datanodeCurrentUser: 'datanodeCurrentUser',
  datanodeSubUser: 'datanodeSubUser',
  datanodeTask: 'datanodeTask',
  datanodeView: 'datanodeView',
  alarmAll: 'alarmAll',
  alarmQuota: 'alarmQuota',
  alarmCollect: 'alarmCollect',
  alarmDeviceOffline: 'alarmDeviceOffline',
  outputEmail: 'outputEmail',
  outputMqtt: 'outputMqtt',
  outputTcp: 'outputTcp'
};

/**
 * 添加元素主题
 */
export const ELE_ADD_TOPIC = {
  eleAdd: 'ELE_ADD',
  action: 'ELE_ADD.ACTION',
  condition: 'ELE_ADD.CONDITION',
  common: 'ELE_ADD.COMMON',
  sink: 'ELE_ADD.SINK',
  object: 'ELE_ADD.OBJECT',
  status: 'ELE_ADD.STATUS',
  custom: 'ELE_ADD.CUSTOM',
  actionlist: 'ELE_ADD.ACTIONLIST',
  trigger: 'ELE_ADD.TRIGGER',
  flowAction: 'ELE_ADD.FLOWACTION',
  note: 'ELE_ADD.NOTE'
};

/**
 * 删除元素主题
 */
export const ELE_DEL_TOPIC = {
  eleDel: 'ELE_DEL',
  action: 'ELE_DEL.ACTION',
  condition: 'ELE_DEL.CONDITION',
  common: 'ELE_DEL.COMMON',
  sink: 'ELE_DEL.SINK',
  object: 'ELE_DEL.OBJECT',
  status: 'ELE_DEL.STATUS',
  custom: 'ELE_DEL.CUSTOM',
  actionlist: 'ELE_DEL.ACTIONLIST',
  trigger: 'ELE_DEL.TRIGGER',
  flowAction: 'ELE_DEL.FLOWACTION',
  note: 'ELE_DEL.NOTE'
};

/**
 * 进入子视图主题
 */
export const ELE_ENTRY_TOPIC = {
  eleEntry: 'ELE_ENTRY',
  // 状态的子视图
  status: 'ELE_ENTRY.STATUS',
  trigger: 'ELE_ENTRY.TRIGGER'
};

/**
 * catalog topic
 */
export const ELE_CATALOG_TOPIC = {
  NORMAL: 'ELE_CATALOG'
};

export const locale = {
  action: '动作',
  flowAction: '动作',
  condition: '条件',
  common: '默认',
  sink: 'Sink',
  source: '对象',
  transform: '转换',
  custom: '自定义',
  object: '对象',
  status: '状态',
  actionlist: '动作串',
  trigger: '触发器',
  note: '注释'
};

const getEleTopic = () => {
  const keys = Object.keys(eleType);
  const result = {
    stage: 'TOIP_STAGE'
  };
  keys.forEach(k => {
    result[k] = `TOIP_STAGE.ELE_${eleType[k].toUpperCase()}`;
  });
  return result;
};

export const eleTypeTopic = getEleTopic();

export const isTriggerEle = (type) => type.indexOf(eleTypeTopic.trigger) === 0;
export const isFlowActionEle = (type) => type.indexOf(eleTypeTopic.flowAction) === 0;

export const stagePosition = {
  spaceX: 110,
  spaceY: 60,
  defaultSpaceY: -150,
  ratio_1: 1,
  ratio_2: 1,
  ratio_3: 3
};

export const catalogPool = {
  object: [ 'status', 'note', 'lineDashed', 'lineSolid' ],
  // status: [ 'trigger', 'note', 'lineDashed', 'lineSolid' ],
  status: [ 'status', 'note', 'lineDashed', 'lineSolid' ],
  trigger: [ 'flowAction', 'note', 'lineDashed', 'lineSolid' ],
  flowAction: [ 'note', 'lineDashed', 'lineSolid' ]
};


export const eleCatalogIconPrefix = '/src/assets/rules/stage/ele-catalog-{icon}.png';

export const completeCatalogIcon = (icon) => {
  return `/src/assets/rules/stage/ele-catalog-${icon}.png`;
};

export const completeItemTypeIcon = (type) => {
  return parseText(stageIconPath, { iconName: type });
};

export const isDragEle = (type = '') => {
  if (eleType[type] && eleType[type] !== ''){
    return true;
  }

  return false;
};

export const isDragLink = (type = '') => {
  if (type === 'lineDashed' || type === 'lineSolid'){
    return true;
  }

  return false;
};

export const isStatusDragLink = (target) => {
  return target && target.className && target.className.indexOf('status-ele') > -1;
};

export const transferDropData = (data = '') => {
  if (data.indexOf('#') > -1){
    const strs = data.split('#');
    return {
      nodeType: strs[0],
      sourceId: strs[1]
    };
  } else {
    return {
      nodeType: data
    };
  }
};

/**
 * 更新
 */
export const ELE_UPDATE_TOPIC = {
  eleUpdate: 'ELE_UPDATE',
  action: 'ELE_UPDATE.ACTION',
  condition: 'ELE_UPDATE.CONDITION',
  common: 'ELE_UPDATE.COMMON',
  sink: 'ELE_UPDATE.SINK',
  object: 'ELE_UPDATE.OBJECT',
  status: 'ELE_UPDATE.STATUS',
  custom: 'ELE_UPDATE.CUSTOM',
  actionlist: 'ELE_UPDATE.ACTIONLIST',
  trigger: 'ELE_UPDATE.TRIGGER',
  flowAction: 'ELE_UPDATE.FLOWACTION',
  note: 'ELE_UPDATE.NOTE'
};

/**
 * 树节点查询
 */
export const TREE_FETCH_TOPIC = {
  treeFetch: 'TREE_FETCH',
  action: 'TREE_FETCH.ACTION',
  condition: 'TREE_FETCH.CONDITION',
  common: 'TREE_FETCH.COMMON',
  sink: 'TREE_FETCH.SINK',
  object: 'TREE_FETCH.OBJECT',
  status: 'TREE_FETCH.STATUS',
  custom: 'TREE_FETCH.CUSTOM',
  actionlist: 'TREE_FETCH.ACTIONLIST',
  trigger: 'TREE_FETCH.TRIGGER',
  flowAction: 'TREE_FETCH.FLOWACTION',
  note: 'TREE_FETCH.NOTE'
};

export const typeValue = (eleType)=>{
  let ruleNodeSourceType = ['datanodeDevice','datanodeCurrentUser','datanodeSubUser','datanodeTask','datanodeView'];
  let ruleNodeBothType = ['alarmAll','alarmQuota','alarmCollect','alarmDeviceOffline'];
  let ruleNodeTargetType = ['outputEmail','outputMqtt','outputTcp'];
  if(ruleNodeSourceType.includes(eleType)){
    return 'source';
  }else if(ruleNodeBothType.includes(eleType)){
    return 'both';
  }else{
    return 'target';
  }
};
