import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Tabs } from 'amos-framework';
import TriggerCondition from './../trigger/condition';

const TabList = Tabs.TabList;
const Tab = Tabs.Tab;
const TabPanel = Tabs.TabPanel;

class StatusTransformTabs extends Component {

  static propTypes = {
    title: PropTypes.string
  };

  static defaultProps = {

  };

  constructor(props) {
    super(props);
    this.state = {
      activeKey: 'condition'
    };
  }

  handleTabChange = (index, key) => {
    this.setState({ activeKey: key });
  }

  render() {
    const { title } = this.props;
    const { activeKey } = this.state;
    return (
      <div className="trigger-editor-attribute">
        <div className="trigger-tabs-title">{title}</div>
        <Tabs className="trigger-tabs" activeKey={activeKey} onChange={this.handleTabChange}>
          <TabList className="trigger-tabslist">
            <Tab key="condition" activeKey="condition">条件</Tab>
          </TabList>
          <TabPanel className="trigger-tabs-panel" key="condition" activeKey="condition">
            <TriggerCondition {...this.props} />
          </TabPanel>
        </Tabs>
      </div>
    );
  }
}

export default StatusTransformTabs;
