import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select } from 'amos-antd';
import { Input } from 'amos-framework';

const Option = Select.Option;
/**
 *
 *
 * @class SearchSectionArea
 * @extends {Component}
 */
class SearchSectionArea extends Component {
  constructor(props){
    super(props);
    this.state = {
      searchParam: {}
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  onSelectedChange = (value,type) => {
    let { searchParam } = this.state;
    searchParam[type] = value;
    this.setState({ searchParam });
  }

  onInputChange = (e) => {
    let { searchParam } = this.state;
    searchParam.name = e.target.value;
    this.setState({ searchParam });
  }

  searchData = () => {
    let { searchParam } = this.state;
    searchParam && this.props.setSearchParam(searchParam);
  }

  getRateContent = () => {
    let content = [];
    for (let i = 0 ; i < 5 ; i++)
    {
      content.push(<Option key={i} value={i}>{i+1}分</Option>);
    }
    return content;
  }

  render() {
    return (
      <div className='search-section-area-root'>
        {/*<div className='recommend-select'>
          <Select
            style={{ width: '160px' }}
            dropdownStyle={{ width: '160px' }}
            dropdownMatchSelectWidth
            onChange={(e)=>this.onSelectedChange(e,'recommend')}
            placeholder='编辑推荐'
            allowClear
          >
            <Option key={1} value={false}>{'不推荐'}</Option>
            <Option key={2} value={true}>{'推荐'}</Option>
          </Select>
    </div>*/}
        <div className='category-select'>
          <Select
            style={{ width: '160px' }}
            dropdownStyle={{ width: '160px' }}
            dropdownMatchSelectWidth
            onChange={(e)=>this.onSelectedChange(e,'type')}
            placeholder='所有分类'
            allowClear
          >
          <Option key={1} value={1}>{'高级应用'}</Option>
          </Select>
        </div>
        <div className='chargeorfree-select'>
          <Select
            style={{ width: '160px' }}
            dropdownStyle={{ width: '160px' }}
            dropdownMatchSelectWidth
            onChange={(e)=>this.onSelectedChange(e,'isFree')}
            placeholder='收费或免费'
            allowClear
          >
            <Option key={1} value={false}>{'免费'}</Option>
            <Option key={2} value={true}>{'收费'}</Option>
          </Select>
        </div>
        <div className='rate-select'>
          <Select
            style={{ width: '160px' }}
            dropdownStyle={{ width: '160px' }}
            dropdownMatchSelectWidth
            onChange={(e)=>this.onSelectedChange(e,'rateValue')}
            placeholder='评分'
            allowClear
          >
            {this.getRateContent()}
          </Select>
        </div>
        <div className='search-section'>
          <Input placeholder="请输入搜索内容" onChange={this.onInputChange} />
          <img src={require('./../../../assets/iot/deviceManage/search.png')} alt='' onClick={this.searchData} />
        </div>
      </div>
    );
  }
}

SearchSectionArea.propTypes = {
  setSearchParam: PropTypes.func
};

export default SearchSectionArea;
