import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Rate } from 'amos-framework';
import SectionOperateArea from './SectionOperateArea';

/**
 *
 *
 * @class SectionCell
 * @extends {Component}
 */
class SectionCell extends Component {
  constructor(props){
    super(props);
    let { content } = this.props;
    this.state = {
      value: content.rateValue,
      hoverValue: 0
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  onChange = (e, value) => {
    this.setState({
      value
    });
  }

  onHoverChange = (e, value) => {
    this.setState({
      hoverValue: value
    });
  }

  render() {
    let { value } = this.state;
    let { content } = this.props;
    return (
      <div tabIndex={'0'} className='section-cell-root'>
        <div className='section-cell-img'>
          <img src={require('./../../../assets/iot/section/section_default.png')} alt='' />
        </div>
        <div className='section-cell-desc'>
          <div className='section-cell-img-title'>{content.name}</div>
          <Rate disabled onChange={this.onChange} value={value} onHoverChange={this.onHoverChange} />
            {<label className='section-cell-rate'>{value} 星</label>}
          <div className='section-cell-installnum'>{content.installTimes}安装</div>
          <div className='section-cell-company'>{content.companyName}</div>
        </div>
        <div style={{ height: '100%',width: '44%',float: 'left' }}>
          <SectionOperateArea />
          <div className='section-cell-comment'>
            {content.descr}
          </div>
        </div>
      </div>
    );
  }
}


SectionCell.propTypes = {
  content: PropTypes.object
};


export default SectionCell;
