import React, { Component } from 'react';
import TopoView from './topoView/TopoView';
import TopoContent from './topoView/TopoContent';
import './topoView/topo.scss';

/**
 * topo管理
 *
 * @class TopoManage
 * @extends {Component}
 */
class TopoManage extends Component {
  constructor(props) {
    super(props);
    this.flag = '1';
    this.state = {
    };
  }

  updateView=(flag,subviewInfo)=>{
    this.flag = flag;
    this.setState({subviewInfo });
  }

  updateBkImg = (imgName) => {
    let { subviewInfo } = this.state;
    subviewInfo.imgName = imgName;
    this.setState({ subviewInfo });
  }

  updateSubviewName = (name) => {
    let { subviewInfo } = this.state;
    subviewInfo.name = name;
    this.flag = subviewInfo.flag;
    this.setState({ subviewInfo });
  }

  showTabPane = () => {
    let {subviewInfo } = this.state;
    let flag = this.flag;
    let orgCode = null;
    let orgName = null;
    let expandedKeys = null;
    if (subviewInfo){
      orgCode = subviewInfo.orgCode;
      orgName = subviewInfo.orgName;
      expandedKeys = subviewInfo.expandedKeys;
    }
    let res = [];
    switch (flag) {
      case '1':
        res.push(<TopoView updateView={this.updateView} orgCode={orgCode} orgName={orgName} expandedKeys={expandedKeys} />);
        break;
      case '2':
        res.push(<TopoContent
          orgCode={orgCode}
          updateBkImg={this.updateBkImg}
          imgName={subviewInfo.imgName}
          subviewId={subviewInfo.id}
          subviewName={subviewInfo.name}
          currentNode={subviewInfo}
          selectedKeys={subviewInfo.id}
          updateView={this.updateView}
          updateSubviewName={this.updateSubviewName}
        />);
        this.flag = '3';
        break;
      case '3':
        res.push(<TopoView updateView={this.updateView} />);
        this.flag = '1';
        break;
      default:res.push(<div>empty</div>);
        break;
    }
    return res;
  }
  render() {
    return (
      <div className="topo-root">
        {
          this.showTabPane()
        }
      </div>
    );
  }
}

export default TopoManage;
