import React, { Component } from 'react';
import PropTypes from 'prop-types';
import dt2react from 'dt2react';
import Icon from 'amos-icon';
import DevicePropertyPanel from './DevicePropertyPanel';
import DeviceCapacityPanel from './DeviceCapacityPanel';
import CapacityInterfacePanel from './CapacityInterfacePanel';

/**
 * 配置界面
 *
 * @class ConfigPanel
 * @extends {Component}
 */
class ConfigPanel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      capacityBasicInfo: {},
      interfaceBasicInfo: {},
      expandStyle: 'empty-property-root'
    };
  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {
    // this.showDeviceCapacityPanel();
    // this.showCapacityInterfacePanel();
  }

  //关闭设备能力面板
  closeDeviceCapacityPanel = () => {
    dt2react.addStyle(this.deviceCapacityPanel,'display','none');
    dt2react.addStyle(this.capacityInterfacePanel,'display','none');
  }

  //关闭设备接口面板
  closeCapacityInterfacePanel = () => {
    dt2react.addStyle(this.capacityInterfacePanel,'display','none');
  }

  //显示设备能力面板
  showDeviceCapacityPanel = (item,getCurrentEquipment) => {
    dt2react.addStyle(this.deviceCapacityPanel,'display','inline');
    if (item !== undefined) {
      this.setState({ capacityBasicInfo: item,getCurrentEquipment });
    }
    this.refs.deviceCapacityNode.changeCollapseSize();
  }

  //显示设备接口面板
  showCapacityInterfacePanel = (item,getCurrentEquipment) => {
    dt2react.addStyle(this.capacityInterfacePanel,'display','inline');
    if (item !== undefined) {
      this.setState({ interfaceBasicInfo: item,getCurrentEquipment });
    }
    this.refs.capacityInterfaceNode.changeCollapseSize();
  }

  clickPanel = () => {
    let { expandStyle } = this.state;
    if (expandStyle === 'empty-property-root-hide') {
      expandStyle = 'empty-property-root';
    } else {
      expandStyle = 'empty-property-root-hide';
    }
    this.setState({ expandStyle });
  }

  showPanel = () => {
    this.setState({ expandStyle: 'empty-property-root' });
  }

  render() {
    let { capacityBasicInfo,interfaceBasicInfo,getCurrentEquipment,expandStyle } = this.state;
    return (
      <div className={expandStyle}>
        <div className="empty-property-btn" onClick={this.clickPanel}>
          <Icon icon={expandStyle === 'empty-property-root-hide' ? 'left' : 'right'} />
        </div>
        {/*<div className='empty-property-btn' onClick={this.clickPanel}>
          {expandStyle === 'empty-property-root-hide' ?
            <img src={require('./../../../assets/iot/img/expand.png')} style={{ position: 'absolute',left: '2px',top: '18px' }} alt='' /> :
            <img src={require('./../../../assets/iot/img/hide.png')} style={{ position: 'absolute',left: '2px',top: '18px' }} alt='' /> }
        </div>*/}
        <div className='empty-property-panel' >
          <div className='config-panel'>
            <div className='capacity-interface-panel' ref={node => this.capacityInterfacePanel = node} >
              <CapacityInterfacePanel
                closeCapacityInterfacePanel={this.closeCapacityInterfacePanel}
                interfaceBasicInfo={interfaceBasicInfo}
                getCurrentEquipment={getCurrentEquipment}
                capacityBasicInfo={capacityBasicInfo}
                ref='capacityInterfaceNode'
                {...this.props}
              />
            </div>
            <div className='device-capacity-panel' ref={node => this.deviceCapacityPanel = node} >
              <DeviceCapacityPanel
                capacityBasicInfo={capacityBasicInfo}
                closeDeviceCapacityPanel={this.closeDeviceCapacityPanel}
                showCapacityInterfacePanel={this.showCapacityInterfacePanel}
                getCurrentEquipment={getCurrentEquipment}
                ref='deviceCapacityNode'
                {...this.props}
              />
            </div>
            <DevicePropertyPanel
              showDeviceCapacityPanel={this.showDeviceCapacityPanel}
              closeCapacityInterfacePanel={this.closeCapacityInterfacePanel}
              {...this.props}
            />
          </div>
        </div>
      </div>
    );
  }
}

ConfigPanel.propTypes = {
  config: PropTypes.object,
  getSubgraphData: PropTypes,
  subviewId: PropTypes.string,
  nodeId: PropTypes.string,
  equipmentId: PropTypes.number,
  updateNodeConfig: PropTypes.func,
  cfgParamJson: PropTypes.object,
  deviceLabel: PropTypes.string,
  deleteNode: PropTypes.func,
  doHiddenProperty: PropTypes.func
};

export default ConfigPanel;
