import CustomNode from './CustomNode';
import GiotNode from './GiotNode';
import NingHuaNode from './NingHuaNode';

const typeToComponentMap = {
  custom: CustomNode, //自定义
  giot: GiotNode, //默认类型
  ninghua: NingHuaNode //宁化节点特殊处理
};

export default function getComponent(nodeType){
  return typeToComponentMap[nodeType] ? typeToComponentMap[nodeType] : CustomNode;
}
