import React from 'react';
import { Editable } from 'amos-framework';
import PropTypes from 'prop-types';

const ElementEditor = props => {
  const textOverFlow = {
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap',
    display: 'inline-block'
  };

  const buttonProps = {
    transparent: true,
    size: 'sm',
    style: {
      margin: 0
    }
  };

  const inputProps = {
    size: 'sm'
  };
  const { label } = props;

  return (
    <Editable
      innerClassName="element-editor"
      defaultValue={label}
      size="sm"
      editIcon={false}
      buttonProps={buttonProps}
      innerValueStyle={textOverFlow}
      inputProps={inputProps}
      showOkCancel={false}
    />
  );
};

ElementEditor.propTypes = {
  label: PropTypes.string,
  eleId: PropTypes.string,
  editCallBack: PropTypes.func
};

export default ElementEditor;
