import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';
import Header from './../../../common/header/Header';

/**
 * stage header
 *
 * @class TopoHeader
 * @extends {Component}
 */
class TopoHeader extends Component {

  static propTypes = {
    title: PropTypes.node,
    extra: PropTypes.node
  };

  render() {

    const { title, extra } = this.props;

    return (
      <div className="topo-view-header">
        <Header
          title={title}
          extra={extra}
        />
      </div>
    );
  }
}

export default TopoHeader;
