import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { calcPermission } from 'amos-processor/lib/config/permission';
import AmosGridTable from './../../common/tableComponent/table/AmosGridTable';
import AddUser from './AddUser';
import EditUser from './EditUser';
import DelUser from './DelUser';
import StartUser from './StartUser';
import StopUser from './StopUser';
import EditPasswordContainer from './EditPasswordContainer';
import { userColumns } from './tableConf';
// import './style/index.scss';
/**
 * 用户管理表格
 * @class UserMgmt
 * @extends {Component}
 */
class UserMgmt extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedRows: [],
      selectedRowKeys: [],
      searchColList: [],
      reload: function(){},
      columns: userColumns
    };
  }

  componentWillReceiveProps(nextProps) {
    if(nextProps.needRefreshTable){
      this.state.reload();
    }
  }
  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows,selectedRowKeys) => {
    this.setState({selectedRows,selectedRowKeys});
  }

  /**
   * 添加表格操作按钮
   */
  addButtons = () => {
    let btns = [];
    let {reload} = this.state;
    // let hasPermission = calcPermission('USER_MGMT');
    btns.push(<AddUser text='新增'  reload={reload} {...this.props} />);
    btns.push(<EditUser text='编辑' reload={reload} selectRows={this.state.selectedRows} {...this.props} />);
    btns.push(<DelUser text='删除' reload={reload} selectRows={this.state.selectedRows} {...this.props} />);
    btns.push(<StartUser text='启用' reload={reload} selectRows={this.state.selectedRows} {...this.props} />);
    btns.push(<StopUser text='禁用' reload={reload} selectRows={this.state.selectedRows} {...this.props} />);
    btns.push(<EditPasswordContainer text='修改密码' reload={reload} selectRows={this.state.selectedRows} {...this.props} />);
    return btns;
  }

  /**
   * 获取表格刷新方法
   */
  reload = (r) => {
    this.setState({reload: ()=>{r();this.setState({selectedRows: [],selectedRowKeys: []});}},r());
  }

  render() {
    let {userTableAction,dataList,totals} = this.props;
    return (
      <div className='table-mgmt-content user-mgmt-table'>
        <AmosGridTable selectedRowKeys={this.state.selectedRowKeys} totals={totals} dataList={dataList} getTableDataAction={userTableAction} columns={this.state.columns} callBack={this.reload} operBtns={this.addButtons()} getSelectedRows={this.getSelectedRows} />
      </div>
    );
  }
}

UserMgmt.propTypes = {
  userTableAction: PropTypes.func,
  dataList: PropTypes.array,
  totals: PropTypes.number
};

export default UserMgmt;
