export const userColumns =  [{
  title: '用户名',
  dataIndex: 'userName',
  query: true,
  required: true,//是否是默认显示的
  primary: true,//是否出现在模糊搜索文本框中
  st: 'text',//搜索的类型
  key: 'userName',
  width: '18%'
}, {
  title: '所属单位',
  dataIndex: 'companyName',
  query: true,
  required: true,//是否是默认显示的
  primary: true,//是否出现在模糊搜索文本框中
  st: 'text',//搜索的类型
  key: 'companyName',
  width: '15%',
  render: (text, record) =>  record && record.company ? record.company.companyName : ''
}, {
  title: '所属部门',
  dataIndex: 'department',
  key: 'department',
  width: '15%',
  render: (text,record) => text ? text.departmentName : ''
},{
  title: '角色',
  dataIndex: 'role',
  key: 'role',
  width: '15%',
  render: (text,record) => text ? text.name : ''
}, {
  title: '手机/固定电话',
  dataIndex: 'contact',
  key: 'contact',
  width: '15%'
},
{
  title: '用户状态',
  dataIndex: 'enabled',
  query: true,
  required: true,//是否是默认显示的
  primary: true,//是否出现在模糊搜索文本框中
  st: 'list',//搜索的类型
  list: [ '启用','禁用' ],//如果 st 的值为列表，则这里需要提供列表内容数组，否则可为 null
  key: 'enabled',
  width: '15%',
  render: (text,record) => text ? '启用' : '禁用'
}];
