import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { PieCharts } from 'amos-core';
import { AmosFetch } from '../../../../utils/processor';
import OltSerUrl from '../../../../consts/urlConsts';
import {
  option,
  option2
} from './chartData/TubeEquipNumData';
/**
 * 纳管设备数量统计
 *
 * @class TubeEquipNum
 * @extends {Component}
 */
class TubeEquipNum extends Component {
  constructor(props) {
    super(props);
    this.state = {
      controller: 0,
      sensor: 0,
      collector: 0,
      electric: 0,
      fire: 0,
      net: 0,
      others: 0,
      industrial: 0
    };
  }

  componentWillMount(){
    let url = `${OltSerUrl.getDeviceCountByType}`;
      //获取接口通讯方式
    AmosFetch.get(url).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
        {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        this.setState({ controller: data.dataList.controller,sensor: data.dataList.sensor,collector: data.dataList.collector });
      }
    });

    let url2 =  `${OltSerUrl.getDeviceCountByIndustry}`;
    AmosFetch.get(url2).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
        {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        this.setState({ electric: data.dataList.electric,fire: data.dataList.fire,net: data.dataList.net,others: data.dataList.others,industrial: data.dataList.industrial });
      }
    });
  }

  render() {
    let { controller,sensor,collector,electric,fire,net,others,industrial } = this.state;
    return (
      <div className="overview-item-chart">
        <div className="overview-tubeequipnum-left">
          <PieCharts
            pieOps={option(controller,sensor,collector)}
            chartStyle={{ width: '100%', height: '309px' }}
          />
        </div>
        <div className="overview-tubeequipnum-right">
          <PieCharts
            pieOps={option2(electric,fire,net,others,industrial)}
            chartStyle={{ width: '100%', height: '309px' }}
          />
        </div>
      </div>
    );
  }
}

export default TubeEquipNum;
