export const option = value => {
  return {
    title: {
      text: '运行数量',
      left: 'center',
      textStyle: {
        color: 'black'
      }
    },
    series: [
      {
        type: 'pie',
        center: ['50%', '50%'], //圆心坐标
        radius: [77, 85], //设置内外环半径
        itemStyle: {
          normal: {
            label: {
              show: false //不显示指引线
            },
            color: '#0099cc'
          }
        },
        data: [
          {
            value: 666, //随便给一个数字即可
            name: '待确认',
            label: {
              normal: {
                show: true,
                position: 'center',
                formatter: value === 0 ? '0' : value + '', //显示中间的数字
                fontSize: 28,
                color: '#0099cc'
              }
            }
          }
        ]
      }
    ]
  };
};

export const option1 = value => {
  return {
    title: {
      text: '暂停数量',
      left: 'center',
      textStyle: {
        color: 'black'
      }
    },
    series: [
      {
        type: 'pie',
        center: ['50%', '50%'], //圆心坐标
        radius: [77, 85], //设置内外环半径
        itemStyle: {
          normal: {
            label: {
              show: false //不显示指引线
            },
            color: '#ff9900'
          }
        },
        data: [
          {
            value: 666, //随便给一个数字即可
            name: '待确认',
            label: {
              normal: {
                show: true,
                position: 'center',
                formatter: value === 0 ? '0' : value + '', //显示中间的数字
                fontSize: 28,
                color: '#ff9900'
              }
            }
          }
        ]
      }
    ]
  };
};

export const option2 = value => {
  return {
    title: {
      text: '覆盖设备数量',
      left: 'center',
      textStyle: {
        color: 'black'
      }
    },
    series: [
      {
        type: 'pie',
        center: ['50%', '50%'], //圆心坐标
        radius: [77, 85], //设置内外环半径
        itemStyle: {
          normal: {
            label: {
              show: false //不显示指引线
            },
            color: '#00cc00'
          }
        },
        data: [
          {
            value: 666, //随便给一个数字即可
            name: '待确认',
            label: {
              normal: {
                show: true,
                position: 'center',
                formatter: value === 0 ? '0' : value + '', //显示中间的数字
                fontSize: 28,
                color: '#00cc00'
              }
            }
          }
        ]
      }
    ]
  };
};

export const option3 = value => {
  return {
    title: {
      text: '覆盖比例',
      left: 'center',
      textStyle: {
        color: 'black'
      }
    },
    series: [
      {
        type: 'pie',
        center: ['50%', '50%'], //圆心坐标
        radius: [77, 85], //设置内外环半径
        itemStyle: {
          normal: {
            label: {
              show: false //不显示指引线
            },
            color: '#ff3399'
          }
        },
        data: [
          {
            value: 666, //随便给一个数字即可
            name: '待确认',
            label: {
              normal: {
                show: true,
                position: 'center',
                formatter: value || '100%', //显示中间的数字
                fontSize: 28,
                color: '#ff3399'
              }
            }
          }
        ]
      }
    ]
  };
};

export const option4 = {
  title: {
    text: '设备模型分别统计',
    left: 'center',
    textStyle: {
      color: 'black'
    }
  },
  series: [
    {
      type: 'pie',
      center: ['50%', '50%'], //圆心坐标
      radius: [77, 85], //设置内外环半径
      itemStyle: {
        normal: {
          label: {
            show: false //不显示指引线
          },
          color: '#0099cc'
        }
      },
      data: [
        {
          value: 666, //随便给一个数字即可
          name: '待确认',
          label: {
            normal: {
              show: true,
              position: 'center',
              formatter: '285', //显示中间的数字
              fontSize: 40,
              color: '#0099cc'
            }
          }
        }
      ]
    }
  ]
};
