"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.default = void 0;
var _react = _interopRequireWildcard(require("react")),
  _propTypes = _interopRequireDefault(require("prop-types")),
  _amosAntd = require("amos-antd"),
  _processor = require("../../../utils/processor"),
  _urlConsts = _interopRequireDefault(require("../../../consts/urlConsts")),
  _dt2react = _interopRequireDefault(require("dt2react")),
  _AmosGridTable = _interopRequireDefault(require("./../../common/tableComponent/table/AmosGridTable")),
  _AlarmDetail = _interopRequireDefault(require("./AlarmDetail"));

function _interopRequireDefault(e) {
  return e && e.__esModule ? e : {
    default: e
  }
}

function _getRequireWildcardCache() {
  if ("function" != typeof WeakMap) return null;
  var e = new WeakMap;
  return _getRequireWildcardCache = function() {
    return e
  }, e
}

function _interopRequireWildcard(e) {
  if (e && e.__esModule) return e;
  if (null === e || "object" !== _typeof(e) && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache();
  if (t && t.has(e)) return t.get(e);
  var r, n, a = {},
    i = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (r in e) Object.prototype.hasOwnProperty.call(e, r) && ((n = i ? Object.getOwnPropertyDescriptor(e, r) : null) && (n.get || n.set) ? Object.defineProperty(a, r, n) : a[r] = e[r]);
  return a.default = e, t && t.set(e, a), a
}

function _typeof(e) {
  return (_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e) {
    return typeof e
  } : function(e) {
    return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
  })(e)
}

function _classCallCheck(e, t) {
  if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
}

function _defineProperties(e, t) {
  for (var r = 0; r < t.length; r++) {
    var n = t[r];
    n.enumerable = n.enumerable || !1, n.configurable = !0, "value" in n && (n.writable = !0), Object.defineProperty(e, n.key, n)
  }
}

function _createClass(e, t, r) {
  return t && _defineProperties(e.prototype, t), r && _defineProperties(e, r), e
}

function _inherits(e, t) {
  if ("function" != typeof t && null !== t) throw new TypeError("Super expression must either be null or a function");
  e.prototype = Object.create(t && t.prototype, {
    constructor: {
      value: e,
      writable: !0,
      configurable: !0
    }
  }), t && _setPrototypeOf(e, t)
}

function _setPrototypeOf(e, t) {
  return (_setPrototypeOf = Object.setPrototypeOf || function(e, t) {
    return e.__proto__ = t, e
  })(e, t)
}

function _createSuper(r) {
  var n = _isNativeReflectConstruct();
  return function() {
    var e, t = _getPrototypeOf(r);
    return _possibleConstructorReturn(this, n ? (e = _getPrototypeOf(this).constructor, Reflect.construct(t, arguments, e)) : t.apply(this, arguments))
  }
}

function _possibleConstructorReturn(e, t) {
  return !t || "object" !== _typeof(t) && "function" != typeof t ? _assertThisInitialized(e) : t
}

function _assertThisInitialized(e) {
  if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  return e
}

function _isNativeReflectConstruct() {
  if ("undefined" == typeof Reflect || !Reflect.construct) return !1;
  if (Reflect.construct.sham) return !1;
  if ("function" == typeof Proxy) return !0;
  try {
    return Date.prototype.toString.call(Reflect.construct(Date, [], function() {})), !0
  } catch (e) {
    return !1
  }
}

function _getPrototypeOf(e) {
  return (_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function(e) {
    return e.__proto__ || Object.getPrototypeOf(e)
  })(e)
}

function _defineProperty(e, t, r) {
  return t in e ? Object.defineProperty(e, t, {
    value: r,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : e[t] = r, e
}
require("./../alarm.scss");
var timestampToTime = function(e) {
    e = new Date(e);
    return "".concat(e.getFullYear(), "-") + "".concat(e.getMonth() + 1 < 10 ? "0".concat(e.getMonth() + 1) : e.getMonth() + 1, "-") + "".concat(e.getDate(), " ") + "".concat(e.getHours(), ":") + "".concat(e.getMinutes(), ":") + e.getSeconds()
  },
  alarmColumns = function(r) {
    return [{
      title: "告警级别",
      dataIndex: "level",
      key: "level",
      width: "8%",
      query: !0,
      required: !0,
      primary: !0,
      st: "list",
      list: [{
        name: "一级",
        value: 1
      }, {
        name: "二级",
        value: 2
      }, {
        name: "三级",
        value: 3
      }],
      render: function(e) {
        return 1 === e ? "一级" : 2 === e ? "二级" : "三级"
      }
    }, {
      title: "告警类型",
      dataIndex: "type",
      key: "type",
      width: "8%",
      query: !0,
      required: !0,
      primary: !0,
      st: "list",
      list: [{
        name: "指标越界",
        value: 1
      }, {
        name: "采集异常",
        value: 2
      }, {
        name: "设备掉线",
        value: 3
      }],
      render: function(e) {
        return 1 === e ? "指标越界" : 2 === e ? "采集异常" : "设备掉线"
      }
    }, {
      title: "告警源",
      dataIndex: "name",
      key: "name",
      query: !0,
      required: !0,
      primary: !0,
      st: "text",
      width: "20%"
    }, {
      title: "描述",
      dataIndex: "descr",
      key: "descr",
      width: "22%"
    }, {
      title: "发生时间",
      dataIndex: "raiseTime",
      key: "raiseTime",
      width: "12%",
      render: function(e) {
        return timestampToTime(e)
      }
    }, {
      title: "清除时间",
      dataIndex: "clearTime",
      key: "clearTime",
      width: "12%",
      render: function(e) {
        return timestampToTime(e)
      }
    }, {
      title: "状态",
      dataIndex: "status",
      key: "status",
      width: "6%",
      render: function(e) {
        return 1 === e ? "未处理" : 2 === e ? "历史告警" : "已删除"
      }
    }, {
      title: "操作",
      key: "action",
      width: "10%",
      render: function(e, t) {
        return _react.default.createElement("span", null, _react.default.createElement(_AlarmDetail.default, {
          alarmInfo: t,
          clearAlarm: function() {
            return r.oneClearAlarm(t.id)
          }
        }), _react.default.createElement("label", {
          className: "delete-alarm-label",
          onClick: function() {
            return r.oneClearAlarm(t.id)
          }
        }, "删除"))
      }
    }]
  },
  headHeight = 278,
  offsetHeight = 160,
  defaultHeight = 450,
  HistoryAlarmTable = function() {
    _inherits(r, _react.Component);
    var t = _createSuper(r);

    function r(e) {
      var a;
      return _classCallCheck(this, r), _defineProperty(_assertThisInitialized(a = t.call(this, e)), "onChange", function(e) {
        var t = e.nodes,
          e = e.connections;
        a.setState({
          nodes: t,
          connections: e
        })
      }), _defineProperty(_assertThisInitialized(a), "onWindowResize", function(e) {}), _defineProperty(_assertThisInitialized(a), "oneClearAlarm", function(e) {
        _amosAntd.Modal.confirm({
          content: "确定删除吗？",
          onCancel: function() {},
          onOk: function() {
            a.clearAlarm([e])
          }
        })
      }), _defineProperty(_assertThisInitialized(a), "getSelectedRows", function(e, t) {
        a.setState({
          selectedRows: e,
          selectedRowKeys: t
        })
      }), _defineProperty(_assertThisInitialized(a), "addButtons", function() {
        var e = [];
        return e.push(_react.default.createElement(_amosAntd.Button, {
          type: "primary",
          onClick: function() {
            return a.batchClearAlarm()
          }
        }, "批量删除")), e
      }), _defineProperty(_assertThisInitialized(a), "alarmDetail", function(e) {}), _defineProperty(_assertThisInitialized(a), "clearAlarm", function(e) {
        e = {
          alarmIds: e,
          status: 3
        };
        _processor.AmosFetch.post(_urlConsts.default.deleteAlarm, {
          data: e
        }).then(function(e) {
          if (e.ok) return e.json();
          throw new Error("从服务端获取数据失败！")
        }).then(function(e) {
          var t, r;
          "SUCCESS" === e.result ? (a.refreshData(a.filter), t = _amosAntd.Modal.warning({
            title: "系统提示",
            content: "删除成功！",
            okText: "确定"
          }), setTimeout(function() {
            return t.destroy()
          }, 2e3)) : (r = _amosAntd.Modal.warning({
            title: "系统提示",
            content: "删除失败！",
            okText: "确定"
          }), setTimeout(function() {
            return r.destroy()
          }, 2e3))
        })
      }), _defineProperty(_assertThisInitialized(a), "fetchCurrentAlarm", function(n, e) {
        n ? a.filter = n : n = a.filter || {}, e ? "{}" === e ? a.searchCondition && (e = a.searchCondition) : a.searchCondition = e : e = a.searchCondition || {};
        var t = [];
        e.level && "-1" !== e.level && t.push({
          name: "level",
          type: "EQUAL",
          value: e.level
        }), e.type && "-1" !== e.type && t.push({
          name: "type",
          type: "EQUAL",
          value: e.type
        }), e.name && t.push({
          name: "name",
          type: "LIKE",
          value: e.name
        }), t.push({
          name: "status",
          type: "EQUAL",
          value: 2
        }), t.push({
          name: "clearTime",
          type: "ORDER BY",
          value: "DESC"
        });
        e = "".concat(_urlConsts.default.getHistoryAlarm, "?pageNumber=").concat(n.current, "&pageSize=").concat(n.pageSize);
        _processor.AmosFetch.post(e, {
          data: t
        }).then(function(e) {
          if (e.ok) return e.json();
          throw new Error("从服务端获取数据失败！")
        }).then(function(e) {
          var t = new Date,
            r = t.getHours(),
            t = t.getMinutes();
          t < 10 && (t = "0".concat(t));
          r = "".concat(r, "时").concat(t, "分");
          "SUCCESS" === e.result ? (t = e.dataList.totalElements, null !== e.content && a.setState({
            dataList: e.dataList.content,
            refreshTime: r,
            total: t,
            filter: n
          })) : a.setState({
            dataList: [],
            refreshTime: r,
            total: 0,
            filter: n
          })
        })
      }), _defineProperty(_assertThisInitialized(a), "batchClearAlarm", function() {
        var e;
        0 !== a.state.selectedRowKeys.length ? _amosAntd.Modal.confirm({
          content: "确定删除吗？",
          onCancel: function() {},
          onOk: function() {
            var e = a.state.selectedRowKeys;
            a.clearAlarm(e)
          }
        }) : (e = _amosAntd.Modal.warning({
          title: "系统提示",
          content: "请选择数据！",
          okText: "确定"
        }), setTimeout(function() {
          return e.destroy()
        }, 2e3))
      }), _defineProperty(_assertThisInitialized(a), "reload", function(e) {
        a.setState({
          reload: function() {
            e(), a.setState({
              selectedRows: [],
              selectedRowKeys: []
            })
          }
        }, e())
      }), _defineProperty(_assertThisInitialized(a), "refreshData", function(e, t) {
        a.fetchCurrentAlarm(e, t)
      }), _defineProperty(_assertThisInitialized(a), "getRefreshTime", function() {
        if (a.state.refreshTime) return a.state.refreshTime;
        var e = new Date,
          t = e.getHours(),
          e = e.getMinutes();
        return e < 10 && (e = "0".concat(e)), "".concat(t, "时").concat(e, "分")
      }), _defineProperty(_assertThisInitialized(a), "refreshTime", function() {
        a.refreshData(a.filter)
      }), _defineProperty(_assertThisInitialized(a), "getPanelHeight", function() {
        var e = a.alarmRoot,
          e = _dt2react.default.getOffset(e) || {};
        return e.height - offsetHeight
      }), a.filter = {
        current: 0,
        pageSize: 10
      }, a.state = {
        dataList: [],
        selectedRows: [],
        selectedRowKeys: [],
        total: 1,
        reload: function() {},
        maxHeight: 450,
        searchCondition: {}
      }, a
    }
    return _createClass(r, [{
      key: "componentDidMount",
      value: function() {
        window.addEventListener("resize", this.onWindowResize), this.props.updateStatus()
      }
    }, {
      key: "componentWillReceiveProps",
      value: function() {}
    }, {
      key: "componentWillUnmount",
      value: function() {
        window.removeEventListener("resize", this.onWindowResize)
      }
    }, {
      key: "render",
      value: function() {
        var t = this,
          e = this.state,
          r = e.dataList,
          n = e.total,
          a = (e.refreshTime, e.maxHeight),
          e = {
            alarmDetail: this.alarmDetail,
            oneClearAlarm: this.oneClearAlarm
          };
        return _react.default.createElement("div", {
          className: "history-alarm-root",
          ref: function(e) {
            return t.alarmRoot = e
          }
        }, _react.default.createElement("div", {
          className: "recent-alarm-table"
        }, _react.default.createElement(_AmosGridTable.default, {
          columns: alarmColumns(e),
          callBack: this.reload,
          dataList: r,
          totals: n,
          getTableDataAction: this.fetchCurrentAlarm,
          getSelectedRows: this.getSelectedRows,
          maxHeight: a,
          getPanelHeight: this.getPanelHeight
        })))
      }
    }]), r
  }();
HistoryAlarmTable.displayName = "HistoryAlarmTable", HistoryAlarmTable.propTypes = {
  updateStatus: _propTypes.default.func
};
var _default = HistoryAlarmTable;
exports.default = HistoryAlarmTable, module.exports = exports.default;
