
import actionCreator from 'amos-processor/lib/redux/actionCreator';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
// import completeSecurityUrl from 'amos-security/lib/consts/securityUrl';

export const USER_ALL_ROLE = 'USER_ALL_ROLE';//用户-获取所有角色
export const USER_ALL_ROLE_SUCCESS = 'USER_ALL_ROLE_SUCCESS';//用户-获取所有角色
export const USER_ALL_ROLE_ERROR = 'USER_ALL_ROLE_ERROR';//用户-获取所有角色

export const USER_REGION_TREE = 'USER_REGION_TREE';//用户-获取区域树
export const USER_REGION_TREE_SUCCESS = 'USER_REGION_TREE_SUCCESS';//用户-获取区域树
export const USER_REGION_TREE_ERROR = 'USER_REGION_TREE_ERROR';//用户-获取区域树

export const USER_TABLE_INFOS = 'USER_TABLE_INFOS';//用户-用户管理表格信息
export const USER_TABLE_INFOS_SUCCESS = 'USER_TABLE_INFOS_SUCCESS';//用户-用户管理表格信息
export const USER_TABLE_INFOS_ERROR = 'USER_TABLE_INFOS_ERROR';//用户-用户管理表格信息

export const USER_DEL = 'USER_DEL';//用户-删除
export const USER_DEL_SUCCESS = 'USER_DEL_SUCCESS';//用户-删除
export const USER_DEL_ERROR = 'USER_DEL_ERROR';//用户-删除

export const USER_ADD = 'USER_ADD';//用户-添加
export const USER_ADD_SUCCESS = 'USER_ADD_SUCCESS';//用户-添加
export const USER_ADD_ERROR = 'USER_ADD_ERROR';//用户-添加

export const USER_EDIT = 'USER_EDIT';//用户-编辑
export const USER_EDIT_SUCCESS = 'USER_EDIT_SUCCESS';//用户-编辑
export const USER_EDIT_ERROR = 'USER_EDIT_ERROR';//用户-编辑

export const USER_INFO = 'USER_INFO';//用户-根据id获取用户信息
export const USER_INFO_SUCCESS = 'USER_INFO_SUCCESS';//用户-根据id获取用户信息
export const USER_INFO_ERROR = 'USER_INFO_ERROR';//用户-根据id获取用户信息

export const USER_DISABLE = 'USER_DISABLE';//用户-用户批量禁用
export const USER_DISABLE_SUCCESS = 'USER_DISABLE_SUCCESS';//用户-用户批量禁用
export const USER_DISABLE_ERROR = 'USER_DISABLE_ERROR';//用户-用户批量禁用

export const USER_ENABLE = 'USER_ENABLE';//用户-用户批量启用
export const USER_ENABLE_SUCCESS = 'USER_ENABLE_SUCCESS';//用户-用户批量启用
export const USER_ENABLE_ERROR = 'USER_ENABLE_ERROR';//用户-用户批量启用

export const USER_EDIT_PASSWORD = 'USER_EDIT_PASSWORD';//用户-编辑用户密码
export const USER_EDIT_PASSWORD_SUCCESS = 'USER_EDIT_PASSWORD_SUCCESS';//用户-编辑用户密码
export const USER_EDIT_PASSWORD_ERROR = 'USER_EDIT_PASSWORD_ERROR';//用户-编辑用户密码

export const USER_DEPARTMENT_TREE_BY_COMPANY = 'USER_DEPARTMENT_TREE_BY_COMPANY';//用户-根据公司选择部门
export const USER_DEPARTMENT_TREE_BY_COMPANY_SUCCESS = 'USER_DEPARTMENT_TREE_BY_COMPANY_SUCCESS';//用户-根据公司选择部门
export const USER_DEPARTMENT_TREE_BY_COMPANY_ERROR = 'USER_DEPARTMENT_TREE_BY_COMPANY_ERROR';//用户-根据公司选择部门

export const USER_COMPANY_SUPERIOR_LIST = 'USER_COMPANY_SUPERIOR_LIST';//用户-获取所有上级单位集合
export const USER_COMPANY_SUPERIOR_LIST_SUCCESS = 'USER_COMPANY_SUPERIOR_LIST_SUCCESS';//用户-获取所有上级单位集合
export const USER_COMPANY_SUPERIOR_LIST_ERROR = 'USER_COMPANY_SUPERIOR_LIST_ERROR';//用户-获取所有上级单位集合

const defaultPageable = {
  current: 0, pageSize: 10
};
/**
 * 构建分页
 */
const buildPageable = (url, pageable = defaultPageable) => {
  let { current, pageSize } = pageable;
  return `${url}?current=${current}&pageSize=${pageSize}`;
};

export default function(base){
  let sysUrl = completeSecurityUrl(base);
  return {
    /**
     * 用户-用户表格
     */
    userTableAction: (pageable, filter, otherFilter) => actionCreator({
      type: USER_TABLE_INFOS,
      method: 'get',
      url: `${buildPageable(sysUrl.userInfos,pageable)}&filter=${filter}${otherFilter}`
    }),
    /**
     * 用户-用户删除
     */
    userDelAction: (ids) => actionCreator({
      type: USER_DEL,
      method: 'del',
      url: `${sysUrl.delUser}?ids=${ids}`
    }),
    /**
     * 用户-用户添加
     */
    userAddAction: (obj) => actionCreator({
      type: USER_ADD,
      method: 'put',
      url: sysUrl.addUser,
      data: obj
    }),
    /**
     * 用户-用户编辑
     */
    userEditAction: (obj) => actionCreator({
      type: USER_EDIT,
      method: 'put',
      url: sysUrl.editUser,
      data: obj
    }),
    /**
     * 用户-用户编辑
     */
    userEditPasswordAction: (obj) => actionCreator({
      type: USER_EDIT_PASSWORD,
      method: 'put',
      url: sysUrl.editPassword,
      data: obj
    }),
    /**
     * 用户-用户批量禁用
     */
    userDisableAction: (ids) => actionCreator({
      type: USER_DISABLE,
      method: 'put',
      url: `${sysUrl.userDisable}/${ids}`
    }),
    /**
     * 用户-用户批量启用
     */
    userEnableAction: (ids) => actionCreator({
      type: USER_ENABLE,
      method: 'put',
      url: `${sysUrl.userEnable}/${ids}`
    }),

    /**
     * 用户-根据id获取用户信息
     */
    getUserByIdAction: (ids) => actionCreator({
      type: USER_INFO,
      method: 'get',
      url: `${sysUrl.getUserById}?userId=${ids}`
    }),
    /**
     * 用户-获取所有角色
     */
    getAllRoleAction: () => actionCreator({
      type: USER_ALL_ROLE,
      method: 'get',
      url: sysUrl.getAllRole
    }),
    /**
     * 用户-获取所有上级单位集合
     * @param {string} companyInfos
     *
     */
    superiorUnitAction: () => actionCreator({
      type: USER_COMPANY_SUPERIOR_LIST,
      method: 'get',
      url: sysUrl.superiorUnitUrl
    }),
    /**
     * 用户-根据公司选择部门
     */
    getDepartmentByCompanyAction: (id) => actionCreator({
      type: USER_DEPARTMENT_TREE_BY_COMPANY,
      method: 'get',
      url: formatUrl(sysUrl.getDepartmentByCompany,{ id })
    })
  };
}


