// @author ilex.h
import { Store } from 'amos-tool';
import RProgress from 'ray-progress';
import * as endConf from 'amos-processor/lib/config/endconf';
// import notFound from 'amos-security/lib/routes/notfound';
// import redirect from 'amos-security/lib/routes/notfound/redirect';
// import signUp, { excludeSignUp } from 'amos-security/lib/routes/signUp';
// import SysConsts from 'amos-security/lib/consts';
import calcRoutes from './calcRoutes';
import addCustomRoutes from './customRoutes';
import pageCompontent, { RootView, Login, RegionList } from './view';

// const apiKey = SysConsts.api_key;
const AmosConfig = endConf.AmosConfig;
const loginURI = AmosConfig.httpURI.loginURI;

const injectRoutes = (menus) => {
  const mainChilds = addCustomRoutes(calcRoutes(menus, pageCompontent));
  const routes = [
    { path: 'login', component: Login },
    { path: 'region', component: RegionList }, // 区域选择
    // ...signUp,
    {
      path: 'main' ,
      component: RootView,
      // indexRoute: {
      //   component: Overview
      // },
      childRoutes: [...mainChilds ]
    },
    // notFound,
    // redirect
  ];

  return routes;
};

// const onEnterValidate = (next, replace, callback) => {
//   progressStart();
//   if (!Store.getCookieByName(apiKey) && next.location.pathname !== '/login'  && excludeSignUp(next.location.pathname) ) {
//     replace('/login');
//   }
//   callback();
// };

const progressStart = () => {
  RProgress.start();
};

const rootRoutes = (menus) => {
  return {
    path: '/',
    // onEnter: onEnterValidate,
    // indexRedirect: RootView,
    onChange: progressStart,
    indexRedirect: Login,
    indexRoute: {
      onEnter(nextState, replace) {
        // replace('/main');
        // replace('/login');
        window.location.href = loginURI;
      }
    },
    childRoutes: injectRoutes(menus)
  };
};

export default rootRoutes;
