import formatUrl from 'amos-processor/lib/utils/urlFormat';
import Url from '../consts/urlConsts';
import { IecUrl } from '../consts/urlConsts';
import { commonGet, commonPost, commonDelete, commonPut } from '../utils/request';

/**
 * 根据条件查询设备类型
 */
export const fetchTemplateStatisticsAction = (data) => {
  return commonPost(Url.fetchTemplateStatistics, data);
};

/**
 * 查询设备类型下所有设备
 */
export const fetchTemplatEquipmentsAction = (id,data) => {
  const url = `${Url.fetchTemplatEquipments}/${id}`;
  return commonPost(url,data);
};

/**
 * 查询设备或模板下所有接口
 */
export const fetchTemplatOrEqpIntfcAction = (eqpTemplId,eqpId) => {
  eqpId = eqpId === undefined ? 0 : eqpId;
  const url = `${Url.fetchTemplatOrEqpIntfc}/${eqpTemplId}/${eqpId}/intfcs`;
  return commonGet(url);
};

/**
 * 编辑设备名称
 */
export const editEquipmentNameAction = (data) => {
  return commonPost(Url.editEquipmentName,data);
};

/**
 * 删除设备
 */
export const deleteEquipmentAction = (ids) => {
  const url = `${Url.delEquipmentById}`;
  return commonDelete(url,ids);
};

/**
 * 删除设备模板
 */
export const deleteEquipmentTemplateAction = (id) => {
  const url = `${Url.deleteDeviceById}/${id}`;
  return commonDelete(url);
};

/**
 * 获取能力信息
 */
export const fetchCapacityListInfoAction = (id) => {
  const url = `${Url.fetchCapacityListInfoById}/${id}`;
  return commonGet(url);
};

/**
 * 查询设备或模板下所有能力
 */
export const fetchTemplatOrEqpQuotaAction = (eqpTemplId,eqpId) => {
  eqpId = eqpId === undefined ? 0 : eqpId;
  const url = `${Url.fetchTemplatOrEqpQuota}/${eqpTemplId}/${eqpId}/cpbls`;
  return commonGet(url);
};

/**
 * 查询设备或模板下所有能力属性
 */
export const fetchTemplatOrEqpQuotaPropertyAction = (eqpId,capId) => {
  eqpId = eqpId === undefined ? 0 : eqpId;
  const url = `${Url.fetchTemplatOrEqpQuota}/${eqpId}/${capId}/cpblAttrs`;
  return commonGet(url);
};


/**
 * 保存设备名称
 */
export const addEditEquipmentAction = (data) => {
  return commonPost(Url.addEditEquipment,data);
};


/**
 * 查询设备或模板下所有能力属性
 */
export const fetchAllTemplatOrEqpQuotaPropertyAction = (eqpTemplId,eqpId) => {
  eqpId = eqpId === undefined ? 0 : eqpId;
  const url = `${Url.fetchTemplatOrEqpQuota}/${eqpTemplId}/${eqpId}/eqpCpblAttrs`;
  return commonGet(url);
};

/**
 * 保存设备名称
 */
export const fetchTopoEquipmentAction = (data) => {
  return commonPost(Url.getRealDevice,data);
};

/**
 * 获取能力下接口
 */
export const fetchCapacityInterfaceAction = (id) => {
  const url = `${Url.fetchCapacityInterface}/${id}`;
  return commonGet(url);
};

/**
 * 查询拓扑中设备所有配置信息
 */
export const fetchTopoDeviceAction = (id) => {
  const url = `${Url.fetchTopoDevice}/${id}`;
  return commonGet(url);
};

export const getChannelByType = (type) => {
  const url = formatUrl(IecUrl.channelListUrl, { type } );
  return commonGet(url);
};

export const createChannel = (param) => {
  return commonPost(IecUrl.channelUrl, param);
};


export const deleteChannel = (id) => {
  const url = formatUrl(IecUrl.deleteChannelUrl, { id } );
  return commonDelete(url);
};

export const getChannelPoint = (channel) => {
  const url = formatUrl(IecUrl.channelPointUrl, { channel } );
  return commonGet(url);
};

export const deleteChannelPoint = (channel) => {
  const url = formatUrl(IecUrl.channelPointUrl, { channel } );
  return commonDelete(url);
};

export const addPoint = (param) => {
  return commonPost(IecUrl.pointUrl, param);
};

export const deletePoint = (ids) => {
  const url = formatUrl(IecUrl.deletePointUrl, { ids } );
  return commonDelete(url);
};


export const getIecChannelPoint = (channelNo, pointType) => {
  const url = formatUrl(IecUrl.iecChannelPointUrl, { channelNo , pointType} );
  return commonGet(url);
};

export const deleteIecChannelPoint = (channelNo, pointType) => {
  const url = formatUrl(IecUrl.iecChannelPointUrl, { channelNo, pointType } );
  return commonDelete(url);
};

export const downloadIecTmpl = () => {
  let a = document.createElement('a')
  a.href = IecUrl.iecDownloadIecTmplUrl;
  a.click();
};