import { utils } from 'amos-tool';

import panelUid from './panelUid';

const property = {
  firstCol: 0,
  secondCol: 3.5,
  width: 3.5,
  height: 7,
  minW: 3.5,
  maxW: 3.5,
  minH: 7,
  maxH: 7
};

export const dataFalcor = (agent, datas) => {
  if (!utils.isArray(datas)){
    datas = [].concat(datas);
  }
  return datas.map(d => d[agent]);
};

export default function(options = {}){

  const { existPanelSize = 0, cardOptions = {}, panelUID } = options;

  const xCol = existPanelSize % 2 === 0 ? property.firstCol : property.secondCol;

  const uid = panelUID || panelUid();

  const panelDataGrid = {
    i: uid,
    x: xCol,
    y: Infinity, // puts it at the bottom
    w: property.width, // 宽度初始默认为4
    h: property.height, // 高度初始为7
    minW: property.minW,
    minH: property.minH,
    // maxW: Infinity,
    // maxH: Infinity,
    maxW: property.maxW,
    maxH: property.maxH,
    draggableHandle: '.triger-panel-darghandle',
    static: false, // If true, equal to `isDraggable: false, isResizable: false`.
    isResizable: false,
    isDraggable: true
  };

  return {
    uid,
    panelDataGrid,
    cardOptions
  };
}
