import React, { Component } from 'react';
import PropTypes from 'prop-types';
/**
 * 实现方式筛选
 *
 * @class ComMethodOptionsFilter
 * @extends {Component}
 */
class IndustryOptionsFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      equiptemplateIndustryOptions: [],
      clearBtnStyle: 'all-filter-btn selected-btn'
    };
  }

  componentWillReceiveProps(nextProps) {
    let equiptemplateIndustryOptions = nextProps.equiptemplateIndustryOptions;
    this.setState({ equiptemplateIndustryOptions });
  }

  //全清
  delFilter = () => {
    let { equiptemplateIndustryOptions,clearBtnStyle } = this.state;
    clearBtnStyle = 'all-filter-btn selected-btn';
    equiptemplateIndustryOptions.map(option=>{
      option.selected = false;
      option.style = 'all-filter-btn';
    });
    this.setState({ equiptemplateIndustryOptions,clearBtnStyle });
    this.props.industrySelectFunc([]);
  }

    //反选‘不限’
    disableAllSelected = () => {
      let clearBtnStyle = 'all-filter-btn selected-btn';
      this.setState({ clearBtnStyle });
    }


  //筛选条件点击事件
  selectClick = (e) => {
    let filterOptionList = [];
    let { equiptemplateIndustryOptions,clearBtnStyle } = this.state;
    clearBtnStyle = 'all-filter-btn';
    equiptemplateIndustryOptions.map(option=>{
      if (option.label === e.target.innerText) {
        option.selected = true;
        option.style = 'all-filter-btn selected-btn';
      }
      if (option.selected) {
        filterOptionList.push(option);
      }
    });
    this.setState({ equiptemplateIndustryOptions,clearBtnStyle });
    this.props.industrySelectFunc(filterOptionList);
  }

  //加载接口通讯方式所有筛选按钮
  AllIndustryOptionFunc = () => {
    let { equiptemplateIndustryOptions,clearBtnStyle } = this.state;
    let res = [];
    res.push(
      <div key={`clear1`} className={clearBtnStyle} onClick={this.delFilter}>
        <div>不限</div>
      </div>);
      if(equiptemplateIndustryOptions != undefined && equiptemplateIndustryOptions.length>0){
        equiptemplateIndustryOptions.map(option=>{
          res.push(<div key={`industry${option.value}`} className={option.style} onClick={this.selectClick}>{option.label}</div>);
        });
      }

    return res;
  }

  render() {
    return (
      this.AllIndustryOptionFunc()
    );
  }
}

IndustryOptionsFilter.propTypes = {
  industrySelectFunc: PropTypes.func,
  equiptemplateIndustryOptions: PropTypes.array
};

export default IndustryOptionsFilter;
