import React from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';
import classnames from 'classnames';

const footerSpans = [
  { key: 'f1', style: { backgroundColor: '#00bbd3' } },
  { key: 'f2', style: { backgroundColor: '#8ac249' } },
  { key: 'f3', style: { backgroundColor: '#fc0' } },
  { key: 'f4', style: { backgroundColor: '#e6564a' } }
];

const SkinItem = props => {

  const { skinImg, name, bgColor = 'transparent', skinUse, onThemeChange } = props;

  const cls = classnames('skin-item', {
    'normal': !skinUse,
    'used': skinUse
  });

  return (
    <div className={cls} onClick={onThemeChange}>
      <img src={skinImg} alt="" />
      <div className="skin-name" style={{ backgroundColor: bgColor }}>{name}</div>
      <div className="skin-footer">
        {
          footerSpans.map(footer => <span key={footer.key} style={footer.style} />)
        }
      </div>
      <div className="skin-check" style={{ backgroundColor: bgColor }}>选用皮肤</div>
      <div className="skin-use" style={{ display: skinUse ? 'block' : 'none' }}>
        <Icon icon="xuanzhong" />使用中
      </div>
    </div>
  );
};

SkinItem.propTypes = {
  skinImg: PropTypes.string,
  name: PropTypes.string,
  bgColor: PropTypes.string,
  skinUse: PropTypes.bool,
  onThemeChange: PropTypes.func
};

SkinItem.defaultProps = {
  skinUse: false
};

export default SkinItem;
