import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Pagination } from 'amos-antd';
import './style/pagination.scss';

class AmosPagination extends Component {
  constructor(props) {
    super(props);

  }

  render() {
    let{total,current,pageSize,onSizeChange,onPaginationChange,selectLength} = this.props;
    let display = {display:selectLength>-1? 'inline':'none'};
    return (
      <div className='amos-pagination-bar'>
{/*        <div className='amos-pagination-total'>
          <span style={display}>已选{selectLength}项,</span>
          <span>共{total}项</span>
        </div>*/}
        <div className='amos-pagination-content'>
          <Pagination size='small' current={current} total={total} pageSize={pageSize} onShowSizeChange={onSizeChange} onChange={onPaginationChange} showSizeChanger showQuickJumper />
        </div>
      </div>
    );
  }
}

AmosPagination.propTypes = {
  total:PropTypes.number,//总数
  current:PropTypes.number,//当前页
  pageSize:PropTypes.number,//当前页
  onSizeChange:PropTypes.func,//当前页
  onPaginationChange:PropTypes.func,//当前页
  selectLength:PropTypes.number
};

AmosPagination.defaultProps = {
  total:0,
  selectLength:-1
};

export default AmosPagination;
