import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, Input, Row, Col, TreeSelect } from 'amos-antd';
import { Select } from 'amos-framework';
import { AmosValidate } from './../../common/utils/processor';
import { textLengthValidate, textValueValidate } from './../../common/utils/validate';

// import './../common/formStyle.scss';
// import './style/index.scss';

const FormItem = Form.Item;
const Option = Select.Option;

const nameText = '单位名称';
const superiorText = '上级单位';
const levelText = '单位级别';
const describesText = '单位描述';
const tipErrorText = '上级名称不能为空！';
const nameErrorText = '单位名称不能为空！';
const levelErrorText = '单位级别不能为空！';

const dataToTree = (dataList = []) => {
  dataList.map((data)=>{
    data.label = data.text;
    data.key = data.id;
    data.value = data.id;
    if (data.children){
      dataToTree(data.children);
    }
  });
};

/**
 * 单位编辑和新建内容
 * @class CompanyAddEdit
 * @extends {Component}
 */
class CompanyAddEdit extends Component {
  constructor(props) {
    super(props);
    this.state = {
      level: props.company.companyLevel,
      fireStationLevels: []
    };
  }

  /**
   * 初始化
   */
  componentDidMount() {
    this.getCompanyLevels();
  }

  componentWillReceiveProps(nextProps) {
    this.setState({ level: nextProps.company.companyLevel });
  }

  /**
   * 获取单位级别列表
   */
  getCompanyLevels = () => {
    this.props.companyLevelsAction();
  }

  companyLevelChange = (e) => {
    this.setState({ level: e });
  }

  /**
   * 校验手机号:这里有bug，需要修复！
   */
  checkMobile = (rule, value, callback) => {
    if (value && !AmosValidate.isPhone(value)) {
      callback('请输入正确的电话号码格式！');
    } else {
      callback();
    }
  }

  /**
   * 校验邮箱
   */
  checkEmail = (rule, value, callback) => {
    if (value && (!AmosValidate.isEmail(value) || value.length > 25)) {
      callback('请输入正确的邮箱格式！');
    } else {
      callback();
    }
  }

  render() {
    const { company,parentform,submit,superiorUnitData,companyLevels } = this.props;
    let { companyName,companyLevel,description,parentId, longitude,siteId, latitude, contact, address, telephone, email } = company;
    const { getFieldProps } = parentform;
    const companyNameProps = getFieldProps('companyName', {
      initialValue: companyName,
      rules: [
          { required: true, message: nameErrorText },
          { validator: textLengthValidate(255, 2) }
      ]
    });
    const superiorUnitProps = getFieldProps('parentId', {
      initialValue: parentId ? `${parentId}` : null,
      rules: [
          { required: this.state.level !== '省总队', message: tipErrorText }
      ]
    });
    const companyLevelProps = getFieldProps('companyLevel', {
      initialValue: null,
      rules: [
          // { required: true,message: levelErrorText }
      ]
      // onChange: this.companyLevelChange
    });
    const companyDescribesProps = getFieldProps('description', {
      initialValue: description,
      rules: [{ validator: textLengthValidate(255) }]
    });
    const longitudeProps = getFieldProps('longitude', {
      initialValue: longitude,
      rules: [
        // { required: true, message: '必填项' },
        { validator: textValueValidate(180, -180) }
      ]
    });
    const latitudeProps = getFieldProps('latitude', {
      initialValue: latitude,
      rules: [
        // { required: true, message: '必填项' },
        { validator: textValueValidate(90, -90) }
      ]
    });
    const contactProps = getFieldProps('contact', {
      initialValue: contact,
      rules: [{ validator: textLengthValidate(10) }]
    });
    const addressProps = getFieldProps('address', {
      initialValue: address,
      rules: [{ validator: textLengthValidate(50) }]
    });
    const telephoneProps = getFieldProps('telephone', {
      initialValue: telephone,
      rules: [{ validator: this.checkMobile }]
    });
    const emailProps = getFieldProps('email', {
      initialValue: null
      // rules: [{ validator: this.checkEmail }]
    })
    const formItemLayout = {
      labelCol: { span: 7 },
      wrapperCol: { span: 16 }
    };
    return (
      <div className='company-add-edit amos-grid-from'>
        <Form inline onSubmit={submit}>
          <Row>
            <Col span={12}>
              <FormItem label={nameText}  {...formItemLayout}>
                <Input className='amos-grid-form-input' {...companyNameProps} style={{ width: 240 }} />
              </FormItem>
            </Col>
            <Col span={12}>
              <FormItem label={superiorText} {...formItemLayout}>
                <TreeSelect
                  instanceId="patent-company"
                  showSearch
                  className='amos-grid-form-select'
                  style={{ width: 240 }}
                  dropdownStyle={{ maxHeight: 250, overflow: 'auto' }}
                  treeData={superiorUnitData}
                  placeholder='上级单位'
                  treeDefaultExpandAll
                  treeNodeFilterProp='title'
                  notFoundContent='无匹配结果'
                  {...superiorUnitProps}
                />
              </FormItem>
            </Col>
          </Row>
          {
            // <Row>
            //   <Col span={12}>
            //     <FormItem label={levelText} {...formItemLayout}>
            //       <Select instanceId="company-levels" className='amos-grid-form-select' disabled={companyLevel === '省总队'} showSearch optionFilterProp="children" {...companyLevelProps} style={{ width: 240 }} >
            //         {
            //         companyLevels.map(e=>(<Option key={`${e}option`} value={e}>{e}</Option>))
            //       }
            //       </Select>
            //     </FormItem>
            //   </Col>
            //   <Col span={12}>
            //     <FormItem label='邮箱' {...formItemLayout} >
            //       <Input className='amos-grid-form-input' {...emailProps} style={{ width: 240 }} />
            //     </FormItem>
            //   </Col>
            // </Row>
          }
          <Row>
            <Col span={12}>
              <FormItem label='经度' {...formItemLayout} >
                <Input className='amos-grid-form-input' {...longitudeProps} style={{ width: 240 }} />
              </FormItem>
            </Col>
            <Col span={12}>
              <FormItem label='纬度' {...formItemLayout} >
                <Input className='amos-grid-form-input' {...latitudeProps} style={{ width: 240 }} />
              </FormItem>
            </Col>
          </Row>
          <Row>
            <Col span={12}>
              <FormItem label='联系人' {...formItemLayout} >
                <Input className='amos-grid-form-input' {...contactProps} style={{ width: 240 }} />
              </FormItem>
            </Col>
            <Col span={12}>
              <FormItem label='地址' {...formItemLayout} >
                <Input className='amos-grid-form-input' {...addressProps} style={{ width: 240 }} />
              </FormItem>
            </Col>
          </Row>
          <Row>
            <Col span={12}>
              <FormItem label='电话' {...formItemLayout} >
                <Input className='amos-grid-form-input' {...telephoneProps} style={{ width: 240 }} />
              </FormItem>
            </Col>
          </Row>
          <Row>
            <Col span={12}>
              <FormItem label={describesText} {...formItemLayout} >
                <Input className='amos-grid-form-textarea'  type='textarea' rows={3} style={{ width: 240 }} {...companyDescribesProps} />
              </FormItem>
            </Col>
          </Row>
        </Form>
      </div>
    );
  }
}

CompanyAddEdit.propTypes = {
  company: PropTypes.object,//单位信息对象
  superiorUnitData: PropTypes.array,//所有上级单位信息对象
  superiorUnitEditData: PropTypes.array,//上级单位及其下属单位信息对象
  submit: PropTypes.func,//保存事件回调
  cancel: PropTypes.func,//取消事件回调
  parentform: PropTypes.any,
  companyLevels: PropTypes.array,
  companyLevelsAction: PropTypes.func
};


CompanyAddEdit.defaultProps = {
  companyLevels: [],
  company: { companyName: '',companyLevel: '',description: '' }
};

export default CompanyAddEdit;
