import React, { Component } from 'react';
import PropTypes from 'prop-types';
import DeviceBasicInfo from './DeviceBasicInfo';
import DeviceConfigInfo from './DeviceConfigInfo';
import DeviceCapacityInfo from './DeviceCapacityInfo';
import DeviceQuotaInfo from './DeviceQuotaInfo';
import OnlineTest from './../onlineTestManger/OnlineTest';


const dataReady = (list,statusSwich) => {
  let newList = [];
  if (list.length > 0){
    list.map((data)=>{
      let id = data.id;
      let flag = true;
      for (let i = 0; i < statusSwich.length; i++) {
        let obj = statusSwich[i];
        if (obj[id] === false) {
          flag = false;
          break;
        }
      }
      if (flag) {
        newList.push(data);
      }
    });
  }
  return newList;
};

/**
 *
 *
 * @class AddDevicePanelBody
 * @extends {Component}
 */
class AddDevicePanelBody extends Component {
  constructor(props){
    super(props);
    this.state = {
      intfcList: [],
      quotaList: [],
      showStatusEditor: false
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  onlinTestSwich = (flag) =>{
    this.setState({
      showStatusEditor: flag
    });
  }
  getIntfcInfo = (data) =>{
    if (data === null){
      this.setState({
        intfcList: []
      });
    } else {
      this.setState({
        intfcList: data
      });
    }
  }

  getQuotaInfo = (data) =>{
    if (data === null){
      this.setState({
        quotaList: []
      });
    } else {
      let { setSumValue } = this.props;
      setSumValue(data.length);
      this.setState({
        quotaList: data
      });
    }
  }

  render() {
    let { intfcList,quotaList } = this.state;
    let { interfaceStatus,quotaCellStatus } = this.props;
    let newIntfcList = dataReady(intfcList,interfaceStatus);
    let newQuotaList = dataReady(quotaList,quotaCellStatus);
    return (
      <div className='add-device-panel-body-root'>
        <div className='add-device-panel-body-left'>
          <DeviceBasicInfo {...this.props} />
          <DeviceConfigInfo {...this.props} />
        </div>
        <div className='add-device-panel-body-right'>
          <DeviceCapacityInfo onlinTestSwich={this.onlinTestSwich} intfcList={newIntfcList} quotaList={newQuotaList} getIntfcInfo={this.getIntfcInfo} {...this.props} />
          <DeviceQuotaInfo getQuotaInfo={this.getQuotaInfo} {...this.props} />
        </div>
      </div>
    );
  }
}

AddDevicePanelBody.propTypes = {
  device: PropTypes.object,
  equipment: PropTypes.object,
  updateInterfaceCellStatus: PropTypes.func,
  updateQuotaCellStatus: PropTypes.func,
  updateDevicePropertyCell: PropTypes.func,
  interfaceStatus: PropTypes.any,
  quotaCellStatus: PropTypes.any,
  setImgFile: PropTypes.func,
  setSumValue: PropTypes.func
};

export default AddDevicePanelBody;
