import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { message } from 'amos-framework';
import './deviceList.scss';
import DeviceListPanelHead from './DeviceListPanelHead';
import DeviceListPanelContent from './DeviceListPanelContent';
import { fetchTemplatEquipmentsAction,deleteEquipmentAction } from './../../../services/deviceService';

/**
 *
 *
 * @class DeviceListPanel
 * @extends {Component}
 */
class DeviceListPanel extends Component {
  constructor(props){
    super(props);
    this.state = {
      equipmentList: [],
      count: 0
    };
  }
  componentWillMount() {

  }

  componentDidMount(){
    this.fetchTemplatEquipments({});
  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  setSearchParam = (name) => {
    this.fetchTemplatEquipments({ name });
  }

  fetchTemplatEquipments = (searchParam) => {
    let { device,outterPageConfig } = this.props;
    if (searchParam.current != null) {
      //前端的current 即后端的pageNumber
      searchParam.pageNumber = searchParam.current;
    }
    if (outterPageConfig) {
      //有参数时用参数的，无参数且有父类值时用父类值
      searchParam.pageSize = searchParam.pageSize !== undefined ? searchParam.pageSize : outterPageConfig.pageSize;
      searchParam.pageNumber = searchParam.pageNumber !== undefined ? searchParam.pageNumber : outterPageConfig.current - 1;
    } else {
      //有参数时用参数的，无参数且无无父类值时用默认值
      searchParam.pageSize = searchParam.pageSize !== undefined ? searchParam.pageSize : 10;
      searchParam.pageNumber = searchParam.pageNumber !== undefined ? searchParam.pageNumber : 0;
    }
    fetchTemplatEquipmentsAction(device.id,searchParam).then(data => {
      let equipmentList = data.content;
      let count = data.totalElements;
      this.setState({ equipmentList,count });
    });
  }

  deleteDeviceById = (ids) => {
    deleteEquipmentAction(ids).then(data => {
      this.fetchTemplatEquipments({});
      message.success('删除成功');
    });
  }

  render() {
    let { equipmentList,count } = this.state;
    let { device } = this.props;
    return (
      <div className='device-list-root'>
        <div className='device-list-head'>
          <DeviceListPanelHead
            device={device}
            setSearchParam={this.setSearchParam}
            deleteDeviceById={this.deleteDeviceById}
            {...this.props}
          />
        </div>
        <DeviceListPanelContent
          deleteDeviceById={this.deleteDeviceById}
          count={count}
          fetchData={this.fetchTemplatEquipments}
          device={device}
          equipmentList={equipmentList}
          {...this.props}
        />
      </div>
    );
  }
}

DeviceListPanel.propTypes = {
  updateMainView: PropTypes.func,
  device: PropTypes.object,
  outterPageConfig: PropTypes.object
};

export default DeviceListPanel;
