import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal } from 'amos-antd';
import { PubSub } from 'ray-eventpool';
import { message } from 'amos-framework';
import dt2react from 'dt2react';
import { EQUIPMENT_BATCH_DELETE_TOPIC } from './../common/ActionConf';
import AmosGridTable from './../../common/tableComponent/table/AmosGridTable';
import { deviceCategoryEnum } from  './../../deviceManage/common/DeviceEnum';
import { stringUtil } from './../../deviceManage/common/DeviceLang';

const deviceColumns = (actions,device,pageConfig) => {
  return [
    {
      title: '设备名称',
      dataIndex: 'name',
      key: 'name',
      width: '16%'
    },{
      title: '设备类型',
      dataIndex: 'tmplName',
      key: 'tmplName',
      width: '12%',
      render: (text, record) => {
        let className = 'tree-td-children';
        if (record.children && record.children.length === 0) {
          className = 'tree-td-children-empty';
        }
        return (<div className={className}>{device.name}</div>);
      }
    },{
      title: '设备类别',
      dataIndex: 'type',
      key: 'type',
      width: '12%',
      render: (text) => stringUtil(deviceCategoryEnum, device.type)
    },{
      title: '所属行业',
      dataIndex: 'industryId',
      key: 'industryId',
      width: '10%',
      render: (text) => device.equipTemplateIndustry.name
    },{
      title: '设备型号',
      dataIndex: 'model',
      key: 'model',
      width: '12%',
      render: (text) => device.model
    },{
      title: '设备描述',
      dataIndex: 'descr',
      key: 'descr',
      width: '16%'
    }, 
    ,{
      title: '所属视图',
      dataIndex: 'nodeName',
      key: 'nodeName',
      width: '12%'
    }, {
      title: '操作',
      key: 'action',
      width: '16%',
      render: (text, record) => (
        <span>
          <label
            className='view-detail'
            onClick={()=>actions.updateMainView({ flag: '5',device,resourceFlag: '3',equipment: record,pageConfig })}
          >详情</label>
          <label className='edit-device' onClick={()=>actions.updateMainView({ flag: '4',device,resourceFlag: '3',equipment: record,pageConfig })} >编辑</label>
          <label className='delete-device' onClick={()=>actions.deleteDevice(record.id)} >删除</label>
        </span>
      )
    }];
};
//偏移110px
const offsetHeight = 110;
const defaultHeight = 450;

/**
 *
 *
 * @class DeviceListPanelContent
 * @extends {Component}
 */
class DeviceListPanelContent extends Component {
  constructor(props){
    super(props);
    this.pageConfig = {
      current: props.outterPageConfig ? props.outterPageConfig.current : 1,
      pageSize: props.outterPageConfig ? props.outterPageConfig.pageSize : 10
    };
    this.state = {
      selectedRows: [],
      selectedRowKeys: [],
      reload(){}
    };
  }
  componentWillMount() {

  }

  componentDidMount(){
    this.batchDelete = PubSub.subscribe(EQUIPMENT_BATCH_DELETE_TOPIC.equipmentBatchDelete, (e,{}) => {
      let { selectedRowKeys } = this.state;
      if (selectedRowKeys.length === 0) {
        message.danger('请选择要删除的设备');
      } else {
        this.deleteMultiDevice(selectedRowKeys);
      }
    });
  }

  componentWillReceiveProps(nextProps) {
    let { equipment } = nextProps;
    if (equipment !== undefined) {
      let { selectedRows, selectedRowKeys } = this.state;
      selectedRows.push(equipment);
      selectedRowKeys.push(equipment.id);
      this.highlight = equipment.id;
    }
  }

  componentWillUnmount() {
    PubSub.unsubscribe(this.batchDelete);
  }

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  }

   /**
   * 获取表格刷新方法
   */
  reload = (r) => {
    this.setState({ reload: ()=>{r();this.setState({ selectedRows: [],selectedRowKeys: [] });} },r());
  }

  deleteDevice = (id) => {
    Modal.confirm({
      content: '确定要删除吗？',
      onCancel: () => {},
      onOk: () => {
        let ids = [id];
        this.props.deleteDeviceById(ids);
      }
    });
  }

  deleteMultiDevice = (ids) => {
    Modal.confirm({
      content: '确定要删除吗？',
      onCancel: () => {},
      onOk: () => {
        this.props.deleteDeviceById(ids);
      }
    });
  }

  getRowClassName = (record,index) => {
    let highlight = this.highlight;
    if (highlight && record.id === highlight) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  }

  setPageConfig = ({ pageSize,current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.current = current;
    }
  }

  getPanelHeight = () => {
    let alarmTablePanel = this.alarmTablePanel;
    let tableLocation = dt2react.getOffset(alarmTablePanel) || {};
    return tableLocation !== undefined ? tableLocation.height - offsetHeight : defaultHeight;
  }

  render() {
    let { equipmentList,fetchData,device,count,updateMainView } = this.props;
    let { reload } = this.state;
    let defaultPageConfig = this.pageConfig;
    let pageConfig = this.pageConfig;
    const actions = { deleteDevice: this.deleteDevice,reload,updateMainView };
    return (
      <div className='device-list-content' ref={node => this.alarmTablePanel = node}>
        <AmosGridTable
          columns={deviceColumns(actions,device,pageConfig)}
          callBack={this.reload}
          dataList={equipmentList}
          totals={count}
          getTableDataAction={fetchData}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          getPanelHeight={this.getPanelHeight}
        />
      </div>
    );
  }
}

DeviceListPanelContent.propTypes = {
  equipmentList: PropTypes.array,
  fetchData: PropTypes.func,
  device: PropTypes.object,
  count: PropTypes.number,
  updateMainView: PropTypes.func,
  deleteDeviceById: PropTypes.func,
  equipment: PropTypes.object,
  outterPageConfig: PropTypes.object
};

export default DeviceListPanelContent;
