import React, { Component } from 'react';
import PropTypes from 'prop-types';
import SimpleCell from './SimpleCell';
import { deviceCategoryEnum } from  './../../deviceManage/common/DeviceEnum';
import { stringUtil } from './../../deviceManage/common/DeviceLang';

/**
 *
 *
 * @class DeviceInfoLeft
 * @extends {Component}
 */
class DeviceInfoLeft extends Component {
  constructor(props){
    super(props);
    this.state = {

    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  getQuotaCell = () => {
    let { device } = this.props;
    let content = [];
    let quotaList = device.quotaList;
    quotaList && quotaList.map(item => {
      content.push(<SimpleCell key={item.id} content={item.name} />);
    });
    return content;
  }

  getInterfaceCell = () => {
    let { device } = this.props;
    let content = [];
    let intfcList = device.intfcList;
    intfcList && intfcList.map(item => {
      content.push(<SimpleCell key={item.id} content={item.displayName} />);
    });
    return content;
  }

  render() {
    let { device } = this.props;
    return (
      <div className='device-info-left-root'>
        <div className='device-info-left-top'>
          <div className='device-info-left-one'>{device.name}</div>
          <div className='device-info-left-two'>
            <label>类别：{stringUtil(deviceCategoryEnum, device.type)}</label>
            <label></label>
          </div>
          <div className='device-info-left-two'>
            <label>行业：{device.equipTemplateIndustry.name}</label>
            <label></label>
          </div>
          <div className='device-info-left-two'>
            <label>型号：{device.model}</label>
            <label></label>
          </div>
          <div className='device-info-left-desc'>
            <label>设备说明：</label>
            <label>{device.descr}</label>
          </div>
        </div>
        <div className='device-info-left-bottom'>
          <img src={require('./../../../assets/iot/deviceManage/const_device.png')} alt='' />
          <div className='interface-cell-text'>接口列表</div>
          <div className='interface-cell-area'>
            {this.getInterfaceCell()}
          </div>
          <div className='capacity-cell-text'>采集指标</div>
          <div className='capacity-cell-area'>
            {this.getQuotaCell()}
          </div>
        </div>
      </div>
    );
  }
}

DeviceInfoLeft.propTypes = {
  device: PropTypes.object
};

export default DeviceInfoLeft;
