import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { message,Modal } from 'amos-framework';
import CommonDeviceCell from './CommonDeviceCell';
import CreateDeviceSearch from './CreateDeviceSearch';
import CreateDeviceLeft from './CreateDeviceLeft';
import './createDeviceHost.scss';
import {
  fetchTemplateStatisticsAction,
  fetchTemplatOrEqpIntfcAction,
  deleteEquipmentTemplateAction,
  fetchTemplatOrEqpQuotaAction
} from './../../../services/deviceService';

/**
 *
 *
 * @class DeviceTypePanel
 * @extends {Component}
 */
class DeviceTypePanel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: {},
      statisticsData: [],
      totalCount:0
    };
  }

  componentDidMount = () => {
    this.questStatistiscData();
  }

  getTemplateContent = () => {
    let { statisticsData } = this.state;
    let content = [];
    statisticsData && statisticsData.map(item => {
      let deviceInfo = item.eqpTemplate;
      deviceInfo && content.push(<CommonDeviceCell
        key={deviceInfo.id}
        deleteTemplate={this.questdeleteNode}
        clickDeviceTemplate={this.clickDeviceTemplate}
        type={2}
        deviceInfo={deviceInfo}
        imgUrl={deviceInfo.img}
        deviceNum={item.count}
        {...this.props}
      />);
    });
    return content;
  }

  setSearchParam = (searchParam) => {
    this.setState({ searchParam });
    this.questStatistiscData(searchParam);
  }

  clickDeviceTemplate = (device) => {
    fetchTemplatOrEqpIntfcAction(device.id).then(data => {
      let intfcList = data;
      Object.assign(device,{ intfcList });
      this.setState({ device });
    });

    fetchTemplatOrEqpQuotaAction(device.id).then(data => {
      let quotaList = data;
      Object.assign(device,{ quotaList });
      this.setState({ device });
    });
  }

  clickMask = () => {
    this.setState({ device: undefined });
  }

  questStatistiscData = (param) => {
    let { searchParam } = this.state;
    param = param === undefined ? searchParam : param;
    fetchTemplateStatisticsAction(param).then(data => {
      let statisticsData = data.data;
      let totalCount = data.totalCount;
      this.setState({ statisticsData: statisticsData
        ,totalCount: totalCount
      });
    });
  }

  questdeleteNode = (id) => {
    if (id !== undefined) {
      let delfunc = this.deleteTemplate;
      Modal.confirm({
        title: '确认删除',
        content: '是否删除所选信息？',
        okText: '确定',
        cancelText: '取消',
        onOk() {
          delfunc(id);
        },
        onCancel() {}
      });
    }
  }

  deleteTemplate = (id) => {
    deleteEquipmentTemplateAction(id).then(item => {
      this.questStatistiscData();
      message.success('删除成功');
      this.clickMask();
    });
  }

  render() {
    let { device,statisticsData,totalCount } = this.state;
    return (
      <div className='create-device-root'>
        <div className='create-device-host-top'>
          <CreateDeviceSearch setSearchParam={this.setSearchParam} />
        </div>
        <div className='create-device-host-bottom' onClick={this.clickMask}>
          <div className='create-device-host-left'>
            <CreateDeviceLeft device={device} statisticsData={statisticsData} totalCount={totalCount} />
          </div>
          <div className='create-device-host-right'>
            {/*<CommonDeviceCell deleteTemplate={this.deleteTemplate} type={1} deviceNum={'6000'} />*/}
            {this.getTemplateContent()}
          </div>
          {/*<div className='create-device-host-mask' onClick={this.clickMask} />*/}
        </div>
      </div>
    );
  }
}

DeviceTypePanel.propTypes = {
  updateMainView: PropTypes.func
};

export default DeviceTypePanel;
