import React, { Component } from 'react';
import DeviceTypePanel from './deviceType/DeviceTypePanel';
import AddDevicePanel from './addEquipment/AddDevicePanel';
import DeviceListPanel from './deviceList/DeviceListPanel';

/**
 *
 * 创建设备
 * @class CreateEquipment
 * @extends {Component}
 */
class CreateEquipment extends Component {
  constructor(props) {
    super(props);
    this.flag = '1';
    this.state = {

    };
  }

  /**
   * flag:
   * device:
   * resourceFlag:
   * equipment:
   *
   * @memberof CreateEquipment
   */
  updateMainView=({ flag,device,resourceFlag,equipment,pageConfig })=>{
    this.flag = flag;
    this.setState({ device,resourceFlag,equipment,pageConfig });
  }

  showTabPane = () => {
    let { device,resourceFlag,equipment,pageConfig } = this.state;
    let flag = this.flag;
    let res = [];
    switch (flag) {
      case '1':
        res.push(<DeviceTypePanel key={'type'} updateMainView={this.updateMainView} />);
        break;
      case '2'://新增
        res.push(<AddDevicePanel key={'add'} enable device={device} resourceFlag={resourceFlag} updateMainView={this.updateMainView} />);
        this.flag = '1';
        break;
      case '3':
        res.push(<DeviceListPanel key={'list'} device={device} equipment={equipment} updateMainView={this.updateMainView} outterPageConfig={pageConfig} />);
        this.flag = '1';
        break;
      case '4'://编辑
        res.push(<AddDevicePanel key={'edit'} enable device={device} equipment={equipment} resourceFlag={resourceFlag} pageConfig={pageConfig} updateMainView={this.updateMainView} />);
        this.flag = '1';
        break;
      case '5'://详情
        res.push(<AddDevicePanel key={'detail'} enable={false} device={device} equipment={equipment} resourceFlag={resourceFlag} updateMainView={this.updateMainView} pageConfig={pageConfig} />);
        this.flag = '1';
        break;
      default:res.push(<div key={'default'}>empty</div>);
        break;
    }
    return res;
  }


  render() {
    return (
      <div style={{ height: '100%' }} className="histroy-root">
        {this.showTabPane()}
      </div>
    );
  }
}

CreateEquipment.propTypes = {

};

export default CreateEquipment;
