import AmosEnum from 'amos-processor/lib/enum/AmosEnum';

const defaultOpts = {
  ignoreCase: true
};

/**
 * 设备类别
 */
export const deviceCategoryEnum = new AmosEnum({
  'controlDevice': 1,
  'transDevice': 2,
  'sensorDevice': 3,
  'otherDevice':4
}, defaultOpts);

/**
 * 数据类型枚举
 */
export const dataTypeEnum = new AmosEnum({
  'int': 1,
  'float': 2,
  'boolean': 3,
  'enum': 4,
  'string': 5,
  'password': 6
}, defaultOpts);

/**
 * 设备属性分类枚举
 */
export const classifyEnum = new AmosEnum({
  'variable': 1,
  'constant': 2,
  'label': 3
}, defaultOpts);

/**
 * 能力属性分类枚举
 */
export const capacatyclassifyEnum = new AmosEnum({
  'variable': 1,
  'constant': 2,
  'label': 3,
  'output': 4
}, defaultOpts);

export const interfaceName = [
  { name: '接口1',value: '1' },
  { name: '接口2',value: '2' },
  { name: '接口3',value: '3' }
];

/**
 *接口方向
 */
export const interfaceDirectionEnum = new AmosEnum({
  'up': 0,
  'down': 1
}, defaultOpts);

/**
 * 设备能力分类
 */
export const capacityClassifyEnum = new AmosEnum({
  'capacityCollect': 1,
  'capacityControl': 2,
  'capacityDiagnosis': 3
}, defaultOpts);
