import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form,Button,Row,Col,Modal } from 'amos-antd';
import { Select } from 'amos-framework';
import { AmosFetch } from '../../../../utils/processor';
import { OltSerUrl } from '../../../../consts/urlConsts';
import { message } from 'amos-framework';
import { interfaceDirectionEnum } from  './../../common/DeviceEnum';
import { enums2array } from './../../common/DeviceLang';

const Option = Select.Option;
const FormItem = Form.Item;
const Direction = enums2array(interfaceDirectionEnum).map((item)=>
  <Option key={item.key} value={`${item.key}`}>{item.label}</Option>) ;
const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 5 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 16 }
  }
};
/**
 *
 * 新增/编辑设备接口
 * @class AddEditCapacityInterface
 * @extends {Component}
 */
class AddEditCapacityInterface extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  componentDidMount(){

  }

   /**
   * 保存按钮事件
   */
  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((errors, values) => {
      if (errors) {
        return;
      }
      this.handleSave(values);
    });
  }

  /**
   *
   *
   * @memberof AddEditCapacityInterface
   */
  handleSave = (obj) => {
    let { interfaceMap,protocolId,capacityId,propertyInfo } = this.props;
    let keyvalue = new Date().getTime();
    let interfaceProList = [{
      key: obj.key,
      displayName: interfaceMap[obj.empIntfcId].interfaceMultiName
    }];
    let { deviceId } = this.props;
    if (deviceId === undefined) {
      //新增设备新增
      Object.assign(obj,{ key: keyvalue });
      //更新device对象
      this.props.addDeviceInterface(obj);
      //更新card
      this.props.autoCardCalculate(interfaceProList);
      this.props.form.resetFields();
      this.props.callBack();
    } else {
      //编辑设备新增
      Object.assign(obj,{ cpblId: capacityId, protocolId,intfcId: interfaceMap[obj.empIntfcId].interfaceID });
      if (propertyInfo.capaIntId){
        obj.id = propertyInfo.capaIntId;
      }
      obj.empIntfcId = interfaceMap[obj.empIntfcId].devIntfcID;
      obj.empTmplIntfcId = obj.empIntfcId;
      //保存到数据库
      this.saveCapacityInterface(obj);

      //更新card
      this.props.getDeviceInfoById(deviceId);
      this.props.form.resetFields();
      this.props.callBack();
    }
  }


  handleCancel = (obj) => {
    this.props.form.resetFields();
    this.props.callBack();
  }

  saveCapacityInterface = (obj) => {
    AmosFetch.post(OltSerUrl.capacityIntfUpdate,{ data: obj }).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        message.success('操作成功！');
      } else {
        message.danger('操作失败！');
      }
    });
  }

  render() {
    let { propertyInfo,form,interfaceMap } = this.props;
    let { empIntfcId } = propertyInfo;
    let { getFieldProps } = form;

    for (let key in interfaceMap){
      let devIntfcID = interfaceMap[key].devIntfcID;
      if (devIntfcID === empIntfcId){
        empIntfcId = key;
      }
    }
    let { interfaceOption } = this.props;
    //接口
    const interfaceProps = getFieldProps('empIntfcId', {
      initialValue: `${empIntfcId}`,
      rules: [
          { required: true, message: '设备接口不能为空！' }
      ]
    });
    return (
      <div className='device-interface-add-modal'>
        <Form horizontal onSubmit={this.handleSubmit}>
          <FormItem {...formItemLayout} hasFeedback label='设备接口: '>
            <Select style={{ width: '100%',height: '32px' }}
              placeholder='接口'
              {...interfaceProps}
            >
              {interfaceOption}
            </Select>
          </FormItem>
          <FormItem wrapperCol={{
            xs: { span: 24, offset: 0 },
            sm: { span: 24, offset: 0 }
          }}
          >
            <Row>
              <Col span={3} offset={14}>
                <Button type="primary" htmlType="submit">提交</Button>
              </Col>
              <Col span={3} offset={1}>
                <Button onClick={this.handleCancel}>取消</Button>
              </Col>
            </Row>
          </FormItem>
        </Form>
      </div>
    );
  }
}

AddEditCapacityInterface.propTypes = {
  form: PropTypes.any,
  callBack: PropTypes.func,
  addDeviceInterface: PropTypes.func,//设备新增
  autoCardCalculate: PropTypes.func,//设备新增
  interfaceOption: PropTypes.array,
  interfaceMap: PropTypes.object,//设备新增
  deviceId: PropTypes.number,
  protocolId: PropTypes.number,
  getDeviceInfoById: PropTypes.func,//详情新增
  capacityId: PropTypes.number,
  propertyInfo: PropTypes.any
};

AddEditCapacityInterface.defaultProps = {
  propertyInfo: { empIntfcId: '' }
};

export default AddEditCapacityInterface;
