import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row,Col,Popover } from 'amos-antd';
import { interfaceDirectionEnum } from  './../../common/DeviceEnum';
import { stringUtil } from './../../common/DeviceLang';
import EditCapacityInterface from './../deviceAddEdit/EditCapacityInterface';
import './../device-detail.scss';

/**
 * 能力接口单元
 *
 * @class CapacityInterfaceCell
 * @extends {Component}
 */
class CapacityInterfaceCell extends Component {
  constructor(props) {
    super(props);
    this.state = {
      textEdit: false
    };
  }

  componentDidMount(){

  }

  /**
   * 处理编辑事件
   *
   * @memberof CapacityInterfaceCell
   */
  handleEditProperty = (e) => {
    console.log();
  }

  /**
   * 处理新增事件
   *
   * @memberof CapacityInterfaceCell
   */
  handleAddProperty = (e) => {
    console.log();
  }

  deleteCurrentCapacityInterface = () => {
    let { propertyInfo } = this.props;
    this.props.deleteInterfaceProperty(propertyInfo.capaIntId);
  }

  render() {
    let { propertyInfo,visibility } = this.props;
    return (
      <div className='capacity-cell-detail' >
        <Row>
          <Col span={24}>
            <div className='capacity-cell-title'>
              <div className='capacity-cell-title-text'>{propertyInfo.intfcName}</div>
              {visibility===1?
              <span>
                <EditCapacityInterface propertyInfo={propertyInfo} {...this.props} />
                <div className='capacity-cell-delete-button' onClick={this.deleteCurrentCapacityInterface}>
                  <img src={require('./../../../../assets/iot/img/mk_delect.png')} alt='' />
                  <label />
                </div>
              </span>
              :null}
            </div>
            <div className='capacity-cell-content'>
              <div>
                <Popover placement="top" title={'接口：'} content={propertyInfo.intfcName} >
                  <div className='single-info'>接口：{propertyInfo.intfcName}</div>
                </Popover>
              </div>
              <div>
                <div className='single-info'>方向：{stringUtil(interfaceDirectionEnum,propertyInfo.intfcDirection)}</div>
              </div>
            </div>
          </Col>
        </Row>
      </div>
    );
  }
}

CapacityInterfaceCell.propTypes = {
  deleteInterfaceProperty: PropTypes.func,
  propertyInfo: PropTypes.object,
  key: PropTypes.number
};

export default CapacityInterfaceCell;
