import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal } from 'amos-antd';
import { AmosFetch } from '../../../../utils/processor';
import { OltSerUrl } from '../../../../consts/urlConsts';
import { message } from 'amos-framework';
import DeviceInterfaceCell from './DeviceInterfaceCell';
import AddDeviceInterface from './../deviceAddEdit/AddDeviceInterface';
import './../device-detail.scss';

/**
 * 设备接口
 *
 * @class DeviceInterface
 * @extends {Component}
 */
class DeviceInterface extends Component {
  constructor(props) {
    super(props);
    this.state = {
      interfaceList: []
    };
  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {
    if ( nextProps.device !== undefined && (nextProps.device !== this.props.device)) {
      this.fetchDeviceInterface(nextProps);
    }
  }

  /**
   * 取设备接口
   *
   * @memberof PrivateDeviceDetail
   */
  fetchDeviceInterface = (nextProps) => {
    let { device } = nextProps;
    let url = `${OltSerUrl.fetchDeviceInterfaceById}/${device.id}`;
    AmosFetch.get(url).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        let dataList = data.dataList;
        let list = [];
        if (dataList !== undefined) {
          for (var index = 0; index < dataList.length; index++) {
            let value = dataList[index];
            list.push(<DeviceInterfaceCell deviceId={device.id} key={index} visibility={device.visibility} propertyInfo={value} deleteInterfaceProperty={this.deleteInterfaceProperty} {...this.props} />);
          }
          this.setState({ interfaceList: list });
          this.props.saveDeviceInterfaces(dataList);
        }
      }
    });
  }

  /**
   * 删除设备接口
   *
   * @memberof PrivateDeviceDetail
   */
  deleteInterfaceProperty = (interfaceId) => {
    let delfunc = this.delInterface;
    Modal.confirm({
      title: '删除',
      content: '是否删除所选属性？',
      okText: '确定',
      cancelText: '取消',
      onOk() { delfunc(interfaceId); },
      onCancel() { }
    });
  }

  delInterface = (interfaceId) => {
    let deviceId = this.props.device.id;
    //删除数据库
    let url = `${OltSerUrl.deleteDeviceInterface}/${interfaceId}`;
    AmosFetch.del(url).then(res => {
      if (res.ok) {
        return res.text();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
    //重新刷新数据
      message.success('删除成功！');
      this.props.getDeviceInfoById(deviceId);
    });
  }

  render() {
    let interfaceList = this.state.interfaceList;
    let { device,getDeviceInfoById } = this.props;
    return (
      <div className='device-interface'>
        <div className='device-detail-interface'>
          <label>设备接口</label>
          {device.visibility ===1?<AddDeviceInterface deviceId={device.id} getDeviceInfoById={getDeviceInfoById} />:null}
        </div>
        <div className='device-detail-interface-content'>
          {interfaceList}
        </div>
      </div>
    );
  }
}

DeviceInterface.propTypes = {
  device: PropTypes.object,
  getDeviceInfoById: PropTypes.func,
  saveDeviceInterfaces: PropTypes.func
};

export default DeviceInterface;
