import React, { Component } from 'react'; import PropTypes from 'prop-types';
import { LineCharts } from 'amos-core';
import { isNum } from 'ray-validate';
import { dateToNoYS } from './../common/date/DateUtil';

const setToolTip = (param,unit) => {
  let text = dateToNoYS(param[0].data[0]);
  text = `${text}<br/>`;
  param.map((item)=>{
    let phase =  item.seriesName;
    let value = item.data[1];
    let img = `<img src="/src/assets/iot/topo/dot/blue.png" alt>`;
    text = `${text} ${img} ${phase} ${value}${unit}<br/>`;
  });
  return text;
};

const dataConversion = (data,legend) => {
  let res = [];
  legend.map((e)=>{
    res.push({
      name: e.name, type: 'line',symbol: e.icon,symbolSize: 6,
      itemStyle: { normal: { color: e.color } },
      lineStyle: { color: e.color },
      areaStyle: { normal: { color: '#E7F3FF' } },
      smooth: true, data: getData(data,e.valueVarName) });
  });
  return res;
};

const getData = (data,valueVarName) => {
  let data1 = data[valueVarName] ? data[valueVarName] : [];
  return data1.map(e=>{
    if (isNum(e.value)){
      return [ e.exeTime,e.value.toFixed(2) ];
    }
  });
};

/**
 * 历史视图
 * @class HistoryChartView
 * @extends {Component}
 */
class HistoryChartView extends Component {
  constructor(props) {
    super(props);
    this.chartOptions = this.chartOptions.bind(this);
  }

  chartOptions() {
    let { unit,interval,min,max,data,legend,axisLabelFormatter } = this.props;
    if (!unit){
      unit = '';
    }
    return {
      tooltip: {
        trigger: 'axis',
        backgroundColor: '#345FA6',
        formatter(params) {
          return setToolTip(params,unit);
        }
      },
      legend: {
        itemWidth: 11,
        itemHeight: 11,
        data: legend,
        bottom: 0
      },
      grid: { left: '3%', right: '4%',top: '13%',bottom: '10%',containLabel: true },
      xAxis: [{
        type: 'value',
        nameTextStyle: { color: '#222',fontSize: 15 },
        nameGap: 20,
        splitLine: { show: false },
        axisLine: { show: true,lineStyle: { color: '#BBB' } },
        // interval,
        splitNumber: 8,
        min,
        max,
        axisLabel: {
          textStyle: { color: '#222',fontSize: 13 },
          formatter(value, index) {
            let func = axisLabelFormatter;
            return func(value);
          }
        }
      }],
      yAxis: {
        name: `单位：${unit}`,nameLocation: 'middle',nameGap: 40,
        type: 'value',splitLine: { lineStyle: { type: 'dotted' } },
        axisLine: { show: false },
        axisTick: { show: false }
      },
      series: dataConversion(data,legend)
    };
  }

  render() {
    let op = this.chartOptions();
    return (
      <div className='three-phase-view'>
        <LineCharts lineOps={op} shouldDispose={this.props.shouldDispose} chartStyle={this.props.chartStyle} />
      </div>
    );
  }
}

HistoryChartView.propTypes = {
  unit: PropTypes.string,
  interval: PropTypes.number,
  min: PropTypes.number,
  max: PropTypes.number,
  axisLabelFormatter: PropTypes.func,
  data: PropTypes.object,
  legend: PropTypes.array,
  chartStyle: PropTypes.object,
  shouldDispose: PropTypes.bool
};

HistoryChartView.defaultProps = {
  data: {},
  legend: [],
  chartStyle: { width: '100%',height: '20rem' }
};

export default HistoryChartView;
