import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { utils } from 'amos-tool';
import { PubSub } from 'ray-eventpool';
import { amosRequest } from 'amos-processor';
import { secExtUrl } from '../consts/urlConsts';
import { browserHistory } from 'amos-react-router'; // react-router
// import { enhanceAuthorization } from 'amos-security';
import Home from './home';
import Header from './main/header';
import LeftMaxContent from './main/LeftMaxContent';
import LeftMinContent from './main/LeftMinContent';

import RightMaxContent from './main/RightMaxContent';
import RightMinContent from './main/RightMinContent';


import { EYE_MODE_CHANGE } from './../consts/topicConsts';

const boxList = [
  { key: 'collection', text: '我的收藏', icon: 'collection', children: [] },
  { key: 'application', text: '我的应用', icon: 'appstore', children: [] },
  { key: 'card', text: '可用卡片', icon: 'card', children: [] }
];

const boxRightList = [
  { key: 'task', text: '周期任务', icon: 'task', children: [] },
  { key: 'message', text: '未读消息', icon: 'xiaoxi', children: [] }
];

const config = {
  slider: 20,
  minScale: 4
};
/**
 * root
 *
 * @class RootView
 * @extends {Component}
 */
class RootView extends Component {

  constructor(props) {
    super(props);
    this.state = {
      eyeMode: true,
      leftExpand: false,
      rightExpand: false,
      leftActiveKey: 'application',
      rightActiveKey: 'task',
      leftCenter: 0,
      rightCenter: 0,
      extendSystem: [{ key: '1', name: '首页', url: '/main' }]
    };
  }

  componentWillMount() {
    this.onSetAppList();
    this.setState({
      leftExpand: false,
      rightExpand: false
    });
  }

  componentDidMount() {
    this.pubsub_eyeModeChange = PubSub.subscribe(EYE_MODE_CHANGE, (topic, eyeMode) => {
      this.setState({
        eyeMode
      });
    });
  }

  // 添加 componentWillReceiveProps
  componentWillReceiveProps(nextProps) {
    if (nextProps.isLoginout) {
      this.context.router ? this.context.router.push('login') : browserHistory.push('login');
    }
  }

  componentWillUnmount() {
    PubSub.unsubscribe(this.pubsub_eyeModeChange);
  }


  onLeftTabChange = (index, key) => {
    this.setState({
      leftActiveKey: key
    });
  }

  onRightTabChange = (index, key) => {
    this.setState({
      rightActiveKey: key
    });
  }

  onSetAppList = (name) => {
    amosRequest(`${secExtUrl.opSearchMenusUrl}?nodeName=${''}`,{ method: 'GET' }).then((data) => {
      let res = (data || {}).dataList || [];
      this.setState({ extendSystem: res });
    });
  }

  closeBox = (type) => {
    this.setState({
      [`${type}Expand`]: false,
      [`${type}Center`]: config.slider * config.minScale
    });
  }

  openBox = ({ type, openKey }) => {
    this.setState({
      [`${type}Expand`]: true,
      [`${type}ActiveKey`]: openKey
    });
  }

  calcCenterStyle = ({ leftOffset = {}, rightOffset = {} }) => {

    if (!utils.isEmpty(leftOffset)) {
      this.setState({
        leftCenter: leftOffset.width + config.slider
      });
    }

    if (!utils.isEmpty(rightOffset)) {
      this.setState({
        rightCenter: rightOffset.width + config.slider
      });
    }
  }


  render() {
    const { eyeMode, rightExpand, rightActiveKey, leftExpand, leftActiveKey } = this.state;
    const { children } = this.props;
    const cls = classnames('view-port', {
      'uneyemode': !eyeMode
    });
    return (
      <div className={cls}>
        <div className="header">
          <Header extendSystem={this.state.extendSystem} />
        </div>
        <div className="content-body">
          <div className="desktop">
            <LeftMaxContent
              display={leftExpand}
              boxList={boxList}
              closeBox={this.closeBox}
              calcCenterStyle={this.calcCenterStyle}
              activeKey={leftActiveKey}
              onTabChange={this.onLeftTabChange}
            />
            { !leftExpand && <LeftMinContent display={!leftExpand} boxList={boxList} openBox={this.openBox} calcCenterStyle={this.calcCenterStyle} /> }
            <div className="main-view">{children || <Home />}</div>
            <RightMaxContent
              display={rightExpand}
              boxList={boxRightList}
              closeBox={this.closeBox}
              calcCenterStyle={this.calcCenterStyle}
              activeKey={rightActiveKey}
              onTabChange={this.onRightTabChange}
            />
            { !rightExpand && <RightMinContent display={leftExpand} boxList={boxRightList} openBox={this.openBox} calcCenterStyle={this.calcCenterStyle} /> }
          </div>
        </div>
      </div>
    );
  }
}

RootView.propTypes = {
  children: PropTypes.node,
  isLoginout: PropTypes.bool
};

// export default enhanceAuthorization(RootView);
