import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal } from 'amos-antd';
import Icon from 'amos-icon';
import { AmosFetch } from '../../../utils/processor';
import OltSerUrl from '../../../consts/urlConsts';
import AlarmDetail from './AlarmDetail';

/**
 *
 * @class AlarmInfoCell
 * @extends {Component}
 */
class AlarmInfoCell extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  componentDidMount(){

  }

  onClick = () => {
    this.props.onHide();
    this.setState({ visible: true });
  }

  handleCancel = (obj) => {
    this.setState({ visible: false });
  }

  clearAlarm= () => {
    let { data } = this.props;
    let ids = [];
    ids.push(data.id);
    let param = {
      alarmIds: ids,
      status: 2,
      remark: '告警已处理！'
    };
    AmosFetch.post(OltSerUrl.deleteAlarm,{ data: param }).then(res => {
      if (res.ok) {
        return res.json();
      } else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        this.props.getAlarmMessageCount();
        this.handleCancel();
        const modal = Modal.warning({
          title: '系统提示',
          content: '清除成功！',
          okText: '确定'
        });
        setTimeout(() => modal.destroy(), 2000);
      } else {
        const modal = Modal.warning({
          title: '系统提示',
          content: '清除失败！',
          okText: '确定'
        });
        setTimeout(() => modal.destroy(), 2000);
      }
    });
  }

  render() {
    let { data,numb,className } = this.props;

    return (
      <div className='middle-context-css' onClick={this.onClick} >
        <div className='cell-alarm-info' >
          <div className={className} >
            <div style={{ marginTop: '-8px' }}><h1>{numb}</h1></div>
          </div>
          <div className='cell-alarm-info-center' >
            <p className='p' >{data.name}</p>
            <p className='p' >{data.descr}</p>
          </div>
          <div className='right-icon-css' ><Icon icon='right' /></div>
        </div>
        <div className='segmenting-line-css' />
        <Modal title='告警详情' visible={this.state.visible} onCancel={this.handleCancel} okText='清除' onOk={this.clearAlarm}>
          <AlarmDetail alarmInfo={data} />
        </Modal>
      </div>
    );
  }
}

AlarmInfoCell.propTypes = {
  data: PropTypes.any,
  numb: PropTypes.any,
  className: PropTypes.any,
  onHide: PropTypes.func,
  getAlarmMessageCount: PropTypes.func
};

export default AlarmInfoCell;
