import React, { Component } from 'react';
import PropTypes from 'prop-types';
import RecentAlarmTable from './table/RecentAlarmTable';
import './alarm.scss';
import AlarmManageMent from './AlarmManageMent';

/**
 *当前告警
 *
 * @class RecentAlarm
 * @extends {Component}
 */
class RecentAlarm extends Component {
  render() {
    let equipmentId = this.props.location.query.param;
    let level =  this.props.location.query.level;
    return (
      <div className='alarm-root'>
        <AlarmManageMent equipmentId={equipmentId} level={level} />
      </div>
    );
  }
}

RecentAlarm.propTypes = {

};

export default RecentAlarm;
