import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { PubSub } from 'ray-eventpool';
import PropertiesBar from './property';
import RuleStage from './RuleStage';
import TriggerEditor from './TriggerEditor';

import { eleTypeTopic, isFlowActionEle } from './modelConf/stageConf';
import RuleConfigPanel from './../ruleSetting/RuleConfigPanel';

class StageLayout extends Component {
  static propTypes = {
    params: PropTypes.object
  }

  constructor(props) {
    super(props);
    this.state = {
      showTriggerEditor: false,
      showStatusEditor: false,
      showFlowDesigner: false,
      // 流程动作id
      actionFlowId: '',
      triggerId: '',
      triggerConfig: {},
      parentConfig: {},
      needReloadStage: false,
      sourceStatus: {},
      targetStatus: {},
      linkId: '',
      config: {}
    };
  }

  componentDidMount() {
    this.pubsub = PubSub.subscribe(eleTypeTopic.stage, (topic, { id, preStatus, nextStatus, config, parentConfig }) => {
      this.setState({
        showStatusEditor: true,
        showFlowDesigner: true,
        actionFlowId: id,
        config: { ...config,id }
      });
      // if (isFlowActionEle(topic)){
      // }
    });
  }

  componentWillUnmount() {
    PubSub.unsubscribe(this.pubsub);
  }

  handleStatusConnLink = (source, target, link) => {
    this.setState({
      sourceStatus: { id: source.id, label: source.textContent },
      targetStatus: { id: target.id, label: target.textContent },
      linkId: link.id,
      showTriggerEditor: false,
      showStatusEditor: true
    });
  }

  closeTriggerDesigner = () => {
    this.setState({
      showTriggerEditor: false,
      showStatusEditor: false
    });
  }

  toggleReloadStage = (flag = false) => {
    this.setState({
      needReloadStage: flag
    });
  }

  render() {
    const { showStatusEditor, needReloadStage,config } = this.state;
    const { params = {} } = this.props;
    const objId = params.libkey;
    return (
      <div className="rule-layout">
        <div className="rule-stage-container">
          <PropertiesBar addNode={this.addNode} />
          <RuleStage
            objId={objId}
            needReloadStage={needReloadStage}
            toggleReloadStage={this.toggleReloadStage}
            onStatusConnLink={this.handleStatusConnLink}
          />
        </div>
        <TriggerEditor
          expanded={showStatusEditor}
          closeDesigner={this.closeTriggerDesigner}
        >
          {
            showStatusEditor && <RuleConfigPanel objId={objId} config={config} closeTriggerDesigner={this.closeTriggerDesigner} />
          }
        </TriggerEditor>
      </div>
    );
  }
}

export default StageLayout;
