import * as React from 'react';
import { PlumbEleNode, placement,plumbNodeConnect  } from 'amos-jsplumb';
import { PubSub } from 'ray-eventpool';
import classNames from 'classnames';
import ActionItem from './../../extra/ActionItem';
import { ELE_DEL_TOPIC, eleTypeTopic, completeItemTypeIcon } from './../../modelConf/stageConf';
import { sourceEndPoint } from './../../modelConf/plumbOptions';
import ElementEditor from './../../ElementEditor';

const DefaultNode = PlumbEleNode.DefaultNode;
const { Anchors } = placement;

/**
 * 数据源
 *
 * @class DataNodeEle
 * @extends {DefaultNode}
 */
@plumbNodeConnect({
  className: 'data-node-ele-inner', 
  sourceParams: {
    filter: '.ele-source-bar',
    allowLoopback: false,
    anchor: Anchors.Right,
    dropOptions: { hoverClass: 'drag-hover' }
  },
  endPointParams: [
    {
      params: sourceEndPoint,
      referenceParams: {
        anchor: Anchors.RightMiddle,
      }
    }
  ]
})

export default function(options){
  const { type, nodeIcon } = options;
  const imgSrc = completeItemTypeIcon(nodeIcon);
  return class DataNodeEle extends React.Component {

    constructor(props) {
      super(props);
      this.currentLabel = this.props.config.label;//再界面上编辑过的值，用以双击打开配置界面时使用
      this.state = {
        active: false
      };
    }


    dbClickTrigger = ({ id, config, parentConfig }) => {
      config.label =  this.currentLabel;
      PubSub.publish(eleTypeTopic.stage, {
        id,
        config,
        parentConfig,
        type
      });
    }

    clickTrigger = () => {
      // this.setState({
      //   active: true
      // });
    }

    remove = (e, { id }) => {
      PubSub.publish(ELE_DEL_TOPIC.trigger, {
        eleId: id
      });
    }

    refreshLabel = (label) => {
      this.currentLabel = label;
    }

    render() {
      const { active } = this.state;
      const { id, config, parentConfig } = this.props;
      const { style, label } = config;
      
      const cls = classNames({
        'node-content-wrapper': true,
        'node-wrapper-active': active
      });

      const wrapperCls = classNames('data-node-ele', nodeIcon);

      return (
        <div
          className={wrapperCls} 
          onDoubleClick={() => this.dbClickTrigger({ id, config, parentConfig })}
        >
          <div className={cls}>
            <div className="ele-node-icon"><img src={imgSrc} alt="" /></div>
            <div className="ele-node-content">
              <ElementEditor
                label={label}
                eleId={id}
                editCallBack={this.refreshLabel}
              />
            </div>
            <div className="ele-node-action">
              <ActionItem
                icon="delete"
                onClick={(e) => this.remove(e, { id })}
                tip="点击删除元素节点"
              />
            </div>
          </div>
        </div>
      )
    }
  };
}
