import React from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';

/**
 * 元素操作
 * @param {Object} props
 */
const ActionItem = ({ icon, onClick, tip }) => {
  return (
    <div className="action-extra-item" onClick={onClick} title={tip}>
      <Icon icon={icon} />
    </div>
  );
};

ActionItem.propTypes = {
  icon: PropTypes.string,
  onClick: PropTypes.func,
  tip: PropTypes.string
};

export default ActionItem;
