import React from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';
import classNames from 'classnames';

/**
 * 元素操作
 * @param {Object} props
 */
const EleCatalog = ({ icon = 'file-tree', onClick, tip, useImg = false }) => {
  const cls = classNames({
    'ele-catalog-operator': true,
    'use-amos-icon': !useImg
  });
  return (
    <div className={cls} onClick={onClick} title={tip}>
      { useImg && <img src={icon} alt="" /> }
      { !useImg && <Icon icon={icon} />}
    </div>
  );
};

EleCatalog.propTypes = {
  icon: PropTypes.string,
  onClick: PropTypes.func,
  tip: PropTypes.string,
  useImg: PropTypes.bool
};

export default EleCatalog;
