/* eslint no-magic-numbers: 0 */
import { placement } from 'amos-jsplumb';

const { Anchors } = placement;

export const allCenterAroundAnchor = [
  Anchors.TopCenter,
  Anchors.RightMiddle,
  Anchors.BottomCenter,
  Anchors.LeftMiddle
];

export const allAroundAnchor = [
  Anchors.Top,
  Anchors.Right,
  Anchors.Bottom,
  Anchors.Left
];

export const colors = {
  basic: 'black',
  dotFill: '#40e2e0',
  dotStroke: '#CCC',
  startDrawLine: '#FF7F0E',
  line: '#4e5568',
  lineActived: '#FF7F0E',
  dotColor: '#0099ff',
  epTarget: '',
  epSource: '',
  hoverColor: '#216477'
};

export const lines = {
  thin: 1,
  normal: 2,
  mid: 3,
  large: 4,
  most: 5
};

// 连线绘画设置
const connectorPaintStyle = {
  strokeWidth: lines.normal,
  stroke: colors.line,
  joinstyle: 'round',
  outlineStroke: 'transparent',
  outlineWidth: lines.normal
};

// .. and this is the hover style.
const connectorHoverStyle = {
  strokeWidth: lines.mid,
  stroke: colors.lineActived,
  outlineWidth: lines.most,
  outlineStroke: 'white'
};

const endpointHoverStyle = {
  fill: colors.lineActived,
  stroke: colors.lineActived
};

export const connectorType = {
  Flowchart: [
    'Flowchart',
    // { stub: [ 10, 15 ], cornerRadius: 20, alwaysRespectStubs: true, midpoint: 0.2 }
    { stub: [ 40, 60 ], gap: 10, cornerRadius: 5, alwaysRespectStubs: true }
  ],
  Bezier: [
    'Bezier',
    { stub: 0, curviness: 150 }
  ],
  StateMachine: [
    'StateMachine',
    {
      curviness: 10,
      margin: 5,
      proximityLimit: 80,
      loopbackRadius: 25,
      showLoopback: true,
      // Valid values are "clockwise" and "anticlockwise". Indicates in which direction a loopback connection should be considered to be travelling.
      orientation: 'clockwise'
    }
  ],
  Straight: [
    'Straight',
    { stub: 0, sourceStub: 10, targetStub: 10, gap: 0, sourceGap: 5, targetGap: 5 }
  ]
};

export const endpointType = {
  Blank: 'Blank',
  Dot: [
    'Dot',
    { radius: 10 }
  ],
  Image: [
    'Image',
    { src: '' }
  ],
  Rectangle: [
    'Rectangle',
    { width: 10, height: 10 }
  ]
};

// 设置当前使用的Connector
const useConnector = connectorType.Bezier;
const useEndpoint = endpointType.Rectangle;

export const sourceEndPoint = {
  endpoint: useEndpoint,
  paintStyle: {
    stroke: '#7AB02C',
    fill: 'transparent',
    radius: 7,
    strokeWidth: 1
  },
  isSource: true,
  connector: useConnector,
  connectorStyle: connectorPaintStyle,
  hoverPaintStyle: endpointHoverStyle,
  connectorHoverStyle,
  dragOptions: {}
};

// the definition of target endpoints (will appear when the user drags a connection)
export const targetEndpoint = {
  endpoint: useEndpoint,
  paintStyle: {
    fill: '#7AB02C',
    radius: 7
  },
  hoverPaintStyle: endpointHoverStyle,
  maxConnections: -1,
  dropOptions: { hoverClass: 'hover', activeClass: 'active' },
  isTarget: true
};

export const jsPlumbOptions = {
  // The default hover style definition to use for all connections. Defaults are null.
  HoverPaintStyle: {
    dashstyle: 'solid',
    // strokeStyle
    stroke: colors.lineActived,
    strokeWidth: lines.normal
  },
  // The default paint style for a connection. Default is line width of 8 pixels, with color "#456".
  PaintStyle: connectorPaintStyle,
  // The default overlay definitions for Connections. Defaults to an empty list.
  ConnectionOverlays: [
    [ 'Arrow',
      { id: 'arrow', location: 1, foldback: 0.8, width: 10, length: 15 }
    ]
  ],
  // Name of the default connector definition to use for all connections. Default is "Bezier"
  Connector: useConnector,
  // The name of the default endpoint to use for all connections (both source and target). Default is "Dot".
  Endpoint: useEndpoint,
  // The default style definition to use for all endpoints. Default is { fill:"#456" }
  EndpointStyle: { radius: 10 },
  // The default hover style definition to use for all endpoints. Default is null.
  EndpointHoverStyle: endpointHoverStyle,
  // Whether or not the jsPlumb log is enabled. defaults to false.
  LogEnabled: false,
  // The default maximum number of connections for an Endpoint. Defaults to 1.
  MaxConnections: 1,
  // Whether or not to reattach Connections that a user has detached with the mouse and then dropped. Default is false.
  ReattachConnections: false
};

/**
 * 注册类型
 */
export const registerTypes = {
  connections: {
    // 虚线样式
    dotted: {
      paintStyle: {
        dashstyle: '3 5',
        outlineStroke: 'transparent',
        // strokeStyle
        stroke: colors.dotColor,
        strokeWidth: lines.normal
      }
    },
    // connections 选中样式
    selected: {
      paintStyle: {
        dashstyle: 'solid',
        strokeWidth: lines.mid,
        outlineStroke: 'transparent',
        outlineWidth: lines.mid,
        // strokeStyle
        stroke: colors.lineActived
      }
    }
  },
  endpoints: {}
};

export const nodeOptions = {
  common: {},
  object: {
    endPointParams: [
      {
        params: sourceEndPoint,
        referenceParams: {
          anchor: Anchors.RightMiddle
        }
      }
    ],
    makeSourceParams: {
      // set only drag line
      filter: '.ele-object-bar',
      allowLoopback: false,
      anchor: Anchors.Right,
      dropOptions: { hoverClass: 'drag-hover' }
    }
  },
  status: {
    endPointParams: [
      {
        params: sourceEndPoint,
        referenceParams: {
          anchor: Anchors.RightMiddle
        }
      },
      {
        params: targetEndpoint,
        referenceParams: {
          anchor: Anchors.LeftMiddle
        }
      }
    ],
    makeTargetParams: {
      allowLoopback: false,
      // left
      anchor: Anchors.ContinuousLeft,
      dropOptions: { hoverClass: 'drag-hover' },
      isTarget: true
    },
    makeSourceParams: {
      filter: '.ele-source-bar',
      allowLoopback: false,
      anchor: Anchors.Right,
      dropOptions: { hoverClass: 'drag-hover' }
    }
  },
  trigger: {
    endPointParams: [
      {
        params: sourceEndPoint,
        referenceParams: {
          anchor: Anchors.RightMiddle
        }
      },
      {
        params: targetEndpoint,
        referenceParams: {
          anchor: Anchors.LeftMiddle
        }
      }
    ],
    makeTargetParams: {
      allowLoopback: false,
      // left
      anchor: Anchors.ContinuousLeft,
      dropOptions: { hoverClass: 'drag-hover' },
      isTarget: true
    },
    makeSourceParams: {
      filter: '.ele-source-bar',
      allowLoopback: false,
      anchor: Anchors.Right,
      dropOptions: { hoverClass: 'drag-hover' }
    }
  },
  flowAction: {
    endPointParams: [
      {
        params: targetEndpoint,
        referenceParams: {
          anchor: Anchors.LeftMiddle
        }
      }
    ],
    makeTargetParams: {
      allowLoopback: false,
      // left
      anchor: Anchors.ContinuousLeft,
      dropOptions: { hoverClass: 'drag-hover' },
      isTarget: true
    }
  }
};
