import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { findDOMNode } from 'React-dom';
import { Form,Icon,Input,Button } from 'amos-antd';
import './style/filter.scss';

const FormItem = Form.Item;
const createForm = Form.create;
const Search = Input.Search;

/**
 * 模糊匹配
 *
 * @class VagueTextFilter
 * @extends {Component}
 */
class VagueTextFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      value: ''
    };
  }

  componentWillReceiveProps(nextProps) {
    if(nextProps.vagueExtra != this.props.vagueExtra){
      this.setState({
        value: ''
      });
    }
  }

  isTextSearch = () => {
    let { filterSearchModel } = this.props;
    let filter = filterSearchModel.filter((e)=> e.primary == true && e.st == 'text');
    return filter;
  }

  handelChange = (evt) => {
    const { needReloadWithApi } = this.props;
    if ( needReloadWithApi ){
      this.handleClick(evt);
    }
    else {
      let value = '';
      if( typeof (evt) ==='object')
      {
        value = evt.target.value;
      }
      else
      {
        value = evt;
      }
      let { invokeFeDataFilter } = this.props;
      this.setState({ value }, invokeFeDataFilter(value));
    }
  }

  /**
   *
   * 从后端api进行模糊过滤
   *
   * @memberof VagueTextFilter
   */
  handleClick = (e) => {

    let primaryFilter = this.isTextSearch()[0];
    let obj = {};
    //obj[primaryFilter.dataIndex] = this.state.value;
    let names = '';
    if ( typeof (e) ==='object')
    {
      names = e.target.value;
    }
    else
    {
      names = e;
    }
    obj[primaryFilter.dataIndex] = names;
    this.props.changeFilters(obj);

    //this.props.changeFilters(e);
  }

  handleReset = (e) => {
    e.preventDefault();
    this.props.form.resetFields();
    this.props.changeFilters({});
    this.setState({
      value: ''
    });
  }

  render() {
    let primaryFilter = this.isTextSearch()[0];
    let display = {display: primaryFilter ? 'block':'none'};
    let placeholder = `${primaryFilter.title}搜索`;
    /*
    if (placeholder === '用户名搜索')
    {
      placeholder = '用户名,状态,单位搜索';
    }
    */
    return (
      <div className='amos-filter-content' style={display} >
        <Form inline onSubmit={this.handleSubmit} className='vague-filter'>
          <FormItem>
            <Search placeholder={placeholder}
              onSearch={value =>this.handelChange(value)}
              //屏蔽掉onChange是出于数据比较多时查询压力太大，导致数据不准确
             // onChange={value =>this.handelChange(value)}
              style={{ width: 200 }}
            />
          </FormItem>
          <Button className='vague-button' onClick={this.handleReset}>
            <Icon onClick={this.handleReset} type="reload" />重置
          </Button>
        </Form>
      </div>
    );
  }
}

VagueTextFilter.propTypes = {
  form: PropTypes.any,
  needReloadWithApi: PropTypes.bool, // 是否需要从后端API获取数据 默认false
  invokeFeDataFilter: PropTypes.func, // 执行前端数据过滤
  vagueExtra: PropTypes.any, // 模糊匹配额外条件
  filterSearchModel: PropTypes.array,//表格列模型，默认值空数组
  changeFilters: PropTypes.func//表格过滤条件变化方法，用于回调获取表格搜索条件
};

VagueTextFilter.defaultProps = {
  invokeFeDataFilter(){},
  needReloadWithApi: false

};

export default createForm()(VagueTextFilter);
