import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button } from 'amos-antd';
import AddEditRule from './addEditRule';

import './common/index.scss';

/**
 * 新增监测规则
 * @class AddRule
 * @extends {Component}
 */
class EditRule extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      isCycle: false  //周期输入框开关，true显示，false不显示
    };
  }

  componentWillMount(){
    let monitorRuleInfo = this.props.monitorRuleInfo;
    if (monitorRuleInfo.monitorType === 1){
      this.setState({
        isCycle: true
      });
    }
  }

  /**
   * 初始化
   */
  componentDidMount() {

  }

  componentWillReceiveProps(nextProps){
    if (nextProps.monitorRuleInfo ){
      if (nextProps.monitorRuleInfo.monitorType === 1){
        this.setState({
          isCycle: true
        });
      }
    }
  }
  /**
   * 打开新增监测规则对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  /**
   * 关闭新增监测规则对话框
   */
  handleCancel = () => {
    this.setState({ visible: false,isCycle: false });
  }

  typeChange =(value)=>{
    let isCycle;
    if ( '1' === value ){
      isCycle = true;
    } else {
      isCycle = false;
    }
    this.setState({
      isCycle
    });
  }

  render() {
    let isCycle = this.state.isCycle;
    let maskClosable = false;
    return (
      <span>
        <Button size='small' onClick={this.onClick} style={{ float: 'left' }} >编辑</Button>
        <Modal title='编辑任务' visible={this.state.visible} width={800} onCancel={this.handleCancel} footer={null} maskClosable={maskClosable}>
          <AddEditRule cancel={this.handleCancel}  flag={'edit'} isCycle={isCycle} typeChange={this.typeChange} {...this.props} />
        </Modal>
      </span>
    );
  }
}

EditRule.propTypes = {
  monitorRuleInfo: PropTypes.any
};

EditRule.defaultProps = {
};
export default EditRule;
