import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button,Table } from 'amos-antd';
import AddEditRule from './addEditRule';

import './common/index.scss';

const monitorObjColumns = (param) => {
  return [{
    title: '名称',
    dataIndex: 'name',
    key: 'name',
    width: '20%'
  }, {
    title: '型号',
    dataIndex: 'model',
    key: 'model',
    width: '20%'
  }, {
    title: '类型',
    dataIndex: 'type',
    key: 'type',
    width: '20%',
    render: (text,record) => text === 1 ? '采集设备' : text === 2 ? '传感设备' : text === 3 ? '控制设备' : ''
  }, {
    title: '描述',
    dataIndex: 'descr',
    key: 'descr',
    width: '40%'
  }];
};

/**
 * 新增监测规则
 * @class AddRule
 * @extends {Component}
 */
class MonitorObjList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  componentWillMount(){

  }

  /**
   * 初始化
   */
  componentDidMount() {

  }

  componentWillReceiveProps(nextProps){
  }

  /**
   * 打开新增监测规则对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  /**
   * 关闭新增监测规则对话框
   */
  handleCancel = () => {
    this.setState({ visible: false });
  }

  render() {
    let flag = false;
    let bordered = true;
    let { text,monitorRuleInfo } = this.props;
    console.log(monitorRuleInfo.deviceObjList);
    return (
      <span>
        <a onClick={this.onClick} >{text}</a>
        <Modal title='监测对象' visible={this.state.visible} width={800} onCancel={this.handleCancel} footer={null} maskClosable={flag}>
          <Table
            columns={monitorObjColumns()}
            dataSource={monitorRuleInfo.deviceObjList}
            bordered={bordered}
            pagination={flag}
          />
        </Modal>
      </span>
    );
  }
}

MonitorObjList.propTypes = {
  text: PropTypes.any,
  monitorRuleInfo: PropTypes.any
};

MonitorObjList.defaultProps = {
};
export default MonitorObjList;
