import React, { Component } from 'react';
import PropTypes from 'prop-types';
import SectionCell from './SectionCell';
import SearchSectionArea from './SearchSectionArea';
import { getSectionsByParamAction } from './../../../services/sectionService';
import './sectionList.scss';

/**
 *
 *
 * @class SectionList
 * @extends {Component}
 */
class SectionList extends Component {
  constructor(props){
    super(props);
    this.state = {

    };
  }
  componentWillMount() {

  }

  componentDidMount(){
    this.getSectionData();
  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  getSectionContent = (data) => {
    let content = [];
    data && data.map(item => {
      content.push(<SectionCell content={item} />);
    });
    return content;
  }

  getSectionData = () => {
    let param = this.param;
    if (param !== undefined) {
      Object.assign(param,{ isRecommend: true });
    } else {
      param = { isRecommend: true };
    }
    getSectionsByParamAction(param).then(data => {
      this.setState({ lastList: data.last,recommendList: data.recommend });
    });
  }

  setSearchParam = (param) => {
    this.param = param;
    this.getSectionData();
    this.getRecommendSectionData();
  }

  showMoreUpdate = () => {

  }

  showMoreCommend = () => {

  }

  render() {
    let { lastList,recommendList } = this.state;
    return (
      <div className='section-list-root'>
        <SearchSectionArea setSearchParam={this.setSearchParam} />
        <div className='section-list-body'>
          <div className='section-list-lastest'>
            <div className='section-list-lastest-text'>最近更新</div>
            <div className='section-list-lastest-more'>
              <img src={require('./../../../assets/iot/section/more.png')} alt='' />
              <div className='section-list-lastest-more-text' onClick={this.showMoreUpdate} >更多</div>
            </div>
          </div>
          <div className='section-list-recommend'>
            <div className='section-list-recommend-text'>精品推荐</div>
            <div className='section-list-recommend-more'>
              <img src={require('./../../../assets/iot/section/more.png')} alt='' />
              <div className='section-list-recommend-more-text' onClick={this.showMoreCommend} >更多</div>
            </div>
          </div>
          <div className='section-list-lastest-content'>
            {this.getSectionContent(lastList)}
          </div>
          <div className='section-list-recommend-content'>
            {this.getSectionContent(recommendList)}
          </div>
        </div>
      </div>
    );
  }
}

SectionList.propTypes = {

};

export default SectionList;
